/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.network.ICloseFilterRemoteExec;
import crazypants.enderio.base.filter.network.PacketFilterUpdate;
import crazypants.enderio.base.filter.network.PacketHeldFilterUpdate;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.GhostSlotTarget;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.network.PacketHandler;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class AbstractFilterGui
extends GuiContainerBaseEIO
implements ICloseFilterRemoteExec.GUI {
    private static final int ID_CLOSE_WINDOW_BUTTON = 12615;
    @Nonnull
    protected final ContainerFilter filterContainer;
    protected final boolean isStickyModeAvailable;
    private final IconButton closeWindowButton;
    @Nonnull
    private final IFilter filter;

    public AbstractFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IFilter filter) {
        this(playerInv, filterContainer, te, filter, "item_filter");
    }

    protected AbstractFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IFilter filter, String ... texture) {
        super((Container)filterContainer, texture);
        this.filterContainer = filterContainer;
        this.field_146999_f = 189;
        this.field_147000_g = 207;
        this.filter = filter;
        this.isStickyModeAvailable = filterContainer.getFilterIndex() == 2;
        this.closeWindowButton = new IconButton((IGuiScreen)this, 12615, 3, 3, (IWidgetIcon)IconEIO.ARROW_LEFT);
        this.closeWindowButton.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_CLOSE.get(), Lang.GUI_ITEM_FILTER_CLOSE_2.get()});
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.closeWindowButton.onGuiInit();
        this.updateButtons();
    }

    protected void func_146976_a(float par1, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_78276_b(this.getUnlocalisedNameForHeading(), this.getGuiLeft() + 28, this.getGuiTop() + 13, ColorUtil.getRGB((Color)Color.DARK_GRAY));
        this.renderCustomOptions(this.getGuiTop() + 13, par1, mouseX, mouseY);
        super.func_146976_a(par1, mouseX, mouseY);
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 12615) {
            this.doCloseFilterGui();
        }
    }

    public void updateButtons() {
    }

    public void renderCustomOptions(int top, float par1, int par2, int par3) {
    }

    @Nonnull
    protected abstract String getUnlocalisedNameForHeading();

    public void sendFilterChange() {
        this.updateButtons();
        TileEntity te = this.filterContainer.getTileEntity();
        if (te != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFilterUpdate(te, this.getFilter(), this.filterContainer.getFilterIndex(), this.filterContainer.getParam1()));
        } else {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketHeldFilterUpdate(this.getFilter(), this.filterContainer.getFilterIndex()));
        }
    }

    @Nonnull
    private IFilter getFilter() {
        return this.filter;
    }

    @Nonnull
    public <I> List<GhostSlotTarget<I>> getTargetSlots() {
        return new ArrayList<GhostSlotTarget<I>>();
    }
}

