/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.registry;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.farmers.TreeFarmer;
import crazypants.enderio.base.farming.registry.Registry;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class Commune
implements IFarmerJoe {
    @Nonnull
    public static final Commune instance = new Commune();
    @Nonnull
    static NNList<ItemStack> disableTrees = new NNList();

    private Commune() {
    }

    @Override
    public boolean canHarvest(final @Nonnull IFarmer farm, final @Nonnull BlockPos bc, final @Nonnull Block block, final @Nonnull IBlockState meta) {
        return Registry.foreach(new Registry.Callback<Boolean>(){

            @Override
            public Boolean run(@Nonnull IFarmerJoe joe) {
                return joe.canHarvest(farm, bc, block, meta) ? Boolean.TRUE : null;
            }
        }) != null;
    }

    @Override
    public IHarvestResult harvestBlock(final @Nonnull IFarmer farm, final @Nonnull BlockPos bc, final @Nonnull Block block, final @Nonnull IBlockState meta) {
        return Registry.foreach(new Registry.Callback<IHarvestResult>(){

            @Override
            public IHarvestResult run(@Nonnull IFarmerJoe joe) {
                return !Commune.this.ignoreTreeHarvest(farm, bc, joe) && joe.canHarvest(farm, bc, block, meta) ? joe.harvestBlock(farm, bc, block, meta) : null;
            }
        });
    }

    @Override
    public boolean prepareBlock(final @Nonnull IFarmer farm, final @Nonnull BlockPos bc, final @Nonnull Block block, final @Nonnull IBlockState meta) {
        return Registry.foreach(new Registry.Callback<Boolean>(){

            @Override
            public Boolean run(@Nonnull IFarmerJoe joe) {
                return joe.prepareBlock(farm, bc, block, meta) ? Boolean.TRUE : null;
            }
        }) != null;
    }

    @Override
    public boolean canPlant(final @Nonnull ItemStack stack) {
        return Registry.foreach(new Registry.Callback<Boolean>(){

            @Override
            public Boolean run(@Nonnull IFarmerJoe joe) {
                return joe.canPlant(stack) ? Boolean.TRUE : null;
            }
        }) != null;
    }

    private boolean ignoreTreeHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, IFarmerJoe joe) {
        if (!(joe instanceof TreeFarmer)) {
            return false;
        }
        ItemStack stack = farm.getSeedTypeInSuppliesFor(bc);
        if (Prep.isInvalid(stack)) {
            return false;
        }
        for (ItemStack disableTreeStack : disableTrees) {
            if (!disableTreeStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public IFarmerJoe setRegistryName(ResourceLocation name) {
        return null;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return null;
    }

    public Class<IFarmerJoe> getRegistryType() {
        return null;
    }
}

