/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.base.farming.farmers.TreeFarmer;
import crazypants.enderio.base.farming.harvesters.IHarvestingTarget;
import crazypants.enderio.util.Prep;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class RubberTreeFarmer
extends TreeFarmer {
    @Nonnull
    protected final ItemStack stickyResin;

    public RubberTreeFarmer(@Nonnull Block sapling, @Nonnull Block wood, @Nonnull Item treetap, @Nonnull ItemStack resin) {
        super(sapling, wood);
        FarmingTool.TREETAP.getThings().add(treetap);
        this.stickyResin = resin;
        FarmersRegistry.slotItemsProduce.add(this.stickyResin);
    }

    public boolean isValid() {
        return !this.saplings.isEmpty() && !this.woods.isEmpty() && !FarmingTool.TREETAP.getThings().isEmpty() && Prep.isValid(this.stickyResin);
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block blockIn, @Nonnull IBlockState meta) {
        if (this.canPlant(farm.getSeedTypeInSuppliesFor(bc))) {
            if (Math.abs(farm.getLocation().func_177958_n() - bc.func_177958_n()) % 2 == 0) {
                return true;
            }
            if (Math.abs(farm.getLocation().func_177952_p() - bc.func_177952_p()) % 2 == 0) {
                return true;
            }
            World world = farm.getWorld();
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos pos = bc.func_177982_a(x, 0, z);
                    IBlockState state = world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block.isLeaves(state, (IBlockAccess)world, pos) || block.isAir(state, (IBlockAccess)world, pos) || block.canBeReplacedByLeaves(state, (IBlockAccess)world, pos)) continue;
                    return true;
                }
            }
            return super.prepareBlock(farm, bc, blockIn, meta);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull IBlockState meta) {
        HarvestResult res = new HarvestResult();
        World world = farm.getWorld();
        this.setupHarvesting(farm, pos);
        while (pos.func_177956_o() <= 255) {
            IBlockState state = world.func_180495_p(pos);
            if (this.isWood(state.func_177230_c())) {
                if (this.canHarvest(world, pos)) {
                    if (farm.hasTool(FarmingTool.TREETAP)) {
                        this.harvest(res, world, pos);
                        farm.registerAction(FarmingAction.HARVEST, FarmingTool.TREETAP, state, pos);
                    } else {
                        farm.setNotification(FarmNotification.NO_TREETAP);
                    }
                }
                this.harvestLeavesAround(farm, world, res, pos);
            } else if (IHarvestingTarget.isDefaultLeaves(state)) {
                this.harvestLeavesBlock(farm, res, world, pos);
            } else {
                return res;
            }
            pos = pos.func_177984_a();
        }
        return res;
    }

    private void harvestLeavesBlock(@Nonnull IFarmer farm, @Nonnull HarvestResult res, @Nonnull World world, @Nonnull BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (IHarvestingTarget.isDefaultLeaves(state)) {
            this.harvestSingleBlock(farm, world, res, pos);
            res.getHarvestedBlocks().add((Object)pos);
            this.harvestLeavesAround(farm, world, res, pos);
        }
    }

    void harvestLeavesAround(final @Nonnull IFarmer farm, final @Nonnull World world, final @Nonnull HarvestResult res, final @Nonnull BlockPos pos) {
        NNList.FACING_HORIZONTAL.apply((NNList.Callback)new NNList.Callback<EnumFacing>(){

            public void apply(@Nonnull EnumFacing face) {
                RubberTreeFarmer.this.harvestLeavesBlock(farm, res, world, pos.func_177972_a(face));
            }
        });
    }

    private boolean canHarvest(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.hasResin(world.func_180495_p(pos));
    }

    private void harvest(@Nonnull HarvestResult res, @Nonnull World world, @Nonnull BlockPos pos) {
        world.func_180501_a(pos, this.removeResin(world.func_180495_p(pos)), 3);
        ItemStack drop = this.makeResin(world.field_73012_v);
        EntityItem dropEnt = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, drop);
        res.getDrops().add((Object)dropEnt);
        res.getHarvestedBlocks().add((Object)pos);
    }

    @Nonnull
    protected ItemStack makeResin(@Nonnull Random rand) {
        return this.stickyResin.func_77946_l();
    }

    protected abstract boolean hasResin(@Nonnull IBlockState var1);

    @Nonnull
    protected abstract IBlockState removeResin(@Nonnull IBlockState var1);
}

