/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.util.Prep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PlantableFarmer
extends IForgeRegistryEntry.Impl<IFarmerJoe>
implements IFarmerJoe {
    private Set<Block> harvestExcludes = new HashSet<Block>();

    public void addHarvestExlude(Block block) {
        this.harvestExcludes.add(block);
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        return stack.func_77973_b() instanceof IPlantable;
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        ItemStack seedStack = farm.getSeedTypeInSuppliesFor(bc);
        if (Prep.isInvalid(seedStack)) {
            if (!farm.isSlotLocked(bc)) {
                farm.setNotification(FarmNotification.NO_SEEDS);
            }
            return false;
        }
        if (!(seedStack.func_77973_b() instanceof IPlantable)) {
            return false;
        }
        IPlantable plantable = (IPlantable)seedStack.func_77973_b();
        EnumPlantType type = plantable.getPlantType((IBlockAccess)farm.getWorld(), bc);
        if (type == null) {
            return false;
        }
        if (type == EnumPlantType.Nether) {
            Block ground = farm.getBlockState(bc.func_177977_b()).func_177230_c();
            if (ground != Blocks.field_150425_aM) {
                return false;
            }
            return this.plantFromInventory(farm, bc, plantable);
        }
        if (type == EnumPlantType.Crop) {
            farm.tillBlock(bc);
            return this.plantFromInventory(farm, bc, plantable);
        }
        if (type == EnumPlantType.Water) {
            return this.plantFromInventory(farm, bc, plantable);
        }
        return false;
    }

    protected boolean plantFromInventory(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IPlantable plantable) {
        World world = farm.getWorld();
        if (this.canPlant(world, bc, plantable) && Prep.isValid(farm.takeSeedFromSupplies(bc))) {
            return this.plant(farm, world, bc, plantable);
        }
        return false;
    }

    protected boolean plant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc, @Nonnull IPlantable plantable) {
        world.func_180501_a(bc, Blocks.field_150350_a.func_176223_P(), 3);
        IBlockState target = plantable.getPlant(null, new BlockPos(0, 0, 0));
        if (target == null) {
            return false;
        }
        world.func_180501_a(bc, target, 3);
        farm.registerAction(FarmingAction.PLANT, FarmingTool.HOE, target, bc);
        return true;
    }

    protected boolean canPlant(@Nonnull World world, @Nonnull BlockPos bc, @Nonnull IPlantable plantable) {
        IBlockState target = plantable.getPlant(null, new BlockPos(0, 0, 0));
        BlockPos groundPos = bc.func_177977_b();
        IBlockState groundBS = world.func_180495_p(groundPos);
        Block ground = groundBS.func_177230_c();
        return target != null && target.func_177230_c().func_176196_c(world, bc) && ground.canSustainPlant(groundBS, (IBlockAccess)world, groundPos, EnumFacing.UP, plantable);
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        if (!this.harvestExcludes.contains(block) && block instanceof IGrowable && !(block instanceof BlockStem)) {
            return !((IGrowable)block).func_176473_a(farm.getWorld(), bc, meta, true);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, final @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull IBlockState meta) {
        if (!this.canHarvest(farm, pos, block, meta)) {
            return null;
        }
        if (!farm.hasTool(FarmingTool.HOE)) {
            farm.setNotification(FarmNotification.NO_HOE);
            return null;
        }
        final World world = farm.getWorld();
        final NNList result = new NNList();
        FakePlayer fakePlayer = farm.startUsingItem(FarmingTool.HOE);
        int fortune = farm.getLootingValue(FarmingTool.HOE);
        ItemStack removedPlantable = Prep.getEmpty();
        NNList drops = new NNList();
        block.getDrops((NonNullList)drops, (IBlockAccess)world, pos, meta, fortune);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)meta, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
        farm.registerAction(FarmingAction.HARVEST, FarmingTool.HOE, meta, pos);
        for (ItemStack stack : drops) {
            if (stack == null || !Prep.isValid(stack) || !(world.field_73012_v.nextFloat() <= chance)) continue;
            if (Prep.isInvalid(removedPlantable) && this.isPlantableForBlock(stack, block)) {
                removedPlantable = stack.func_77946_l();
                removedPlantable.func_190920_e(1);
                stack.func_190918_g(1);
            }
            if (!Prep.isValid(stack)) continue;
            result.add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l()));
        }
        NNList.wrap(farm.endUsingItem(FarmingTool.HOE)).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                result.add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop.func_77946_l()));
            }
        });
        if (Prep.isValid(removedPlantable)) {
            if (!this.plant(farm, world, pos, (IPlantable)removedPlantable.func_77973_b())) {
                result.add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, removedPlantable.func_77946_l()));
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        return new HarvestResult((NNList<EntityItem>)result, pos);
    }

    private boolean isPlantableForBlock(@Nonnull ItemStack stack, @Nonnull Block block) {
        if (!(stack.func_77973_b() instanceof IPlantable)) {
            return false;
        }
        IPlantable plantable = (IPlantable)stack.func_77973_b();
        IBlockState b = plantable.getPlant(null, new BlockPos(0, 0, 0));
        return b != null && b.func_177230_c() == block;
    }
}

