/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PlaceableFarmer
extends IForgeRegistryEntry.Impl<IFarmerJoe>
implements IFarmerJoe {
    @Nonnull
    private final Things DIRT;
    @Nonnull
    private final Things SEEDS;

    public PlaceableFarmer(String ... seeds) {
        this("block:minecraft:dirt", seeds);
    }

    public PlaceableFarmer(@Nonnull String dirt, @Nonnull String[] seeds) {
        this(new String[]{dirt}, seeds);
    }

    public PlaceableFarmer(@Nonnull String[] dirt, @Nonnull String[] seeds) {
        this.SEEDS = new Things(seeds);
        this.DIRT = new Things(dirt);
    }

    public void addSeed(@Nonnull String seed) {
        this.SEEDS.add(seed);
    }

    public void addDirt(@Nonnull String dirt) {
        this.DIRT.add(dirt);
    }

    public boolean isValid() {
        return !this.SEEDS.isEmpty() && !this.DIRT.isEmpty();
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        return this.SEEDS.contains(stack);
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        IBlockState blockStateGround = farm.getBlockState(bc.func_177977_b());
        Block ground = blockStateGround.func_177230_c();
        if (!this.DIRT.contains(ground)) {
            return false;
        }
        ItemStack seedStack = farm.getSeedTypeInSuppliesFor(bc);
        if (!this.canPlant(seedStack)) {
            if (!farm.isSlotLocked(bc)) {
                farm.setNotification(FarmNotification.NO_SEEDS);
            }
            return false;
        }
        return this.plant(farm, bc, meta);
    }

    protected boolean plant(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState state) {
        ItemStack seedStack = farm.takeSeedFromSupplies(bc);
        if (Prep.isValid(seedStack)) {
            FakePlayer joe = farm.startUsingItem(seedStack);
            EnumActionResult res = seedStack.func_77973_b().func_180614_a((EntityPlayer)joe, joe.field_70170_p, bc.func_177977_b(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
            farm.handleExtraItems(farm.endUsingItem(FarmingTool.HOE), bc);
            if (res == EnumActionResult.SUCCESS) {
                farm.registerAction(FarmingAction.PLANT, FarmingTool.HOE, state, bc);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        return null;
    }
}

