/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.CustomSeedFarmer;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class PickableFarmer
extends CustomSeedFarmer {
    public PickableFarmer(@Nonnull Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, @Nonnull ItemStack seeds) {
        super(plantedBlock, plantedBlockMeta, grownBlockMeta, seeds);
    }

    public PickableFarmer(@Nonnull Block plantedBlock, int grownBlockMeta, @Nonnull ItemStack seeds) {
        super(plantedBlock, grownBlockMeta, seeds);
    }

    public PickableFarmer(@Nonnull Block plantedBlock, @Nonnull ItemStack seeds) {
        super(plantedBlock, seeds);
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, final @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        if (!this.canHarvest(farm, bc, block, meta)) {
            return null;
        }
        if (!farm.hasTool(FarmingTool.HOE)) {
            farm.setNotification(FarmNotification.NO_HOE);
            return null;
        }
        final HarvestResult result = new HarvestResult();
        final World world = farm.getWorld();
        FakePlayer joe = farm.startUsingItem(FarmingTool.HOE);
        joe.field_71134_c.func_187251_a((EntityPlayer)joe, joe.field_70170_p, joe.func_184614_ca(), EnumHand.MAIN_HAND, bc, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
        NNList.wrap(farm.endUsingItem(FarmingTool.HOE)).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                result.getDrops().add((Object)new EntityItem(world, (double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5, drop.func_77946_l()));
            }
        });
        farm.registerAction(FarmingAction.HARVEST, FarmingTool.HOE, meta, bc);
        result.getHarvestedBlocks().add((Object)bc);
        return result;
    }
}

