/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FlowerPicker
extends IForgeRegistryEntry.Impl<IFarmerJoe>
implements IFarmerJoe {
    protected Things flowers = new Things();

    public FlowerPicker(@Nonnull Things flowers) {
        this.add(flowers);
    }

    public FlowerPicker add(@Nonnull Things newFlowers) {
        this.flowers.add(newFlowers);
        FarmersRegistry.slotItemsProduce.add(newFlowers);
        return this;
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        return false;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        return this.flowers.contains(block) || block instanceof IShearable;
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, final @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull IBlockState meta) {
        final World world = farm.getWorld();
        NNList drops = new NNList();
        if (block instanceof IShearable) {
            if (!farm.hasTool(FarmingTool.SHEARS)) {
                farm.setNotification(FarmNotification.NO_SHEARS);
                return null;
            }
            ItemStack shears = farm.getTool(FarmingTool.SHEARS);
            if (!((IShearable)block).isShearable(shears, (IBlockAccess)world, pos)) {
                return null;
            }
            drops.addAll((Collection)((IShearable)block).onSheared(shears, (IBlockAccess)world, pos, farm.getLootingValue(FarmingTool.SHEARS)));
            farm.registerAction(FarmingAction.HARVEST, FarmingTool.SHEARS, meta, pos);
        } else {
            if (!farm.hasTool(FarmingTool.HOE)) {
                farm.setNotification(FarmNotification.NO_HOE);
                return null;
            }
            block.getDrops((NonNullList)drops, (IBlockAccess)world, pos, meta, farm.getLootingValue(FarmingTool.HOE));
            farm.registerAction(FarmingAction.HARVEST, FarmingTool.HOE, meta, pos);
        }
        final NNList result = new NNList();
        NNList.wrap((List)drops).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                result.add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop.func_77946_l()));
            }
        });
        world.func_175698_g(pos);
        return new HarvestResult((NNList<EntityItem>)result, pos);
    }
}

