/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CustomSeedFarmer
extends IForgeRegistryEntry.Impl<IFarmerJoe>
implements IFarmerJoe {
    @Nonnull
    protected final Block plantedBlock;
    protected final int plantedBlockMeta;
    protected final int grownBlockMeta;
    @Nonnull
    protected final ItemStack seeds;
    @Nonnull
    protected Things tilledBlocks = new Things();
    protected boolean ignoreSustainCheck = false;
    protected boolean requiresTilling = true;
    protected boolean checkGroundForFarmland = false;
    protected boolean disableTreeFarm;

    public CustomSeedFarmer(@Nonnull Block plantedBlock, @Nonnull ItemStack seeds) {
        this(plantedBlock, 0, 7, seeds);
    }

    public CustomSeedFarmer(@Nonnull Block plantedBlock, int grownBlockMeta, @Nonnull ItemStack seeds) {
        this(plantedBlock, 0, grownBlockMeta, seeds);
    }

    public CustomSeedFarmer(@Nonnull Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, @Nonnull ItemStack seeds) {
        this.plantedBlock = plantedBlock;
        this.plantedBlockMeta = plantedBlockMeta;
        this.grownBlockMeta = grownBlockMeta;
        this.seeds = seeds;
        FarmersRegistry.slotItemsSeeds.add(seeds);
        this.addTilledBlock(Blocks.field_150458_ak);
    }

    public void clearTilledBlocks() {
        this.tilledBlocks = new Things();
    }

    public void addTilledBlock(@Nonnull Things block) {
        this.tilledBlocks.add(block);
    }

    public void addTilledBlock(@Nonnull Block block) {
        this.tilledBlocks.add(block);
    }

    public boolean isIgnoreGroundCanSustainCheck() {
        return this.ignoreSustainCheck;
    }

    @Nonnull
    public CustomSeedFarmer setIgnoreGroundCanSustainCheck(boolean ignoreSustainCheck) {
        this.ignoreSustainCheck = ignoreSustainCheck;
        return this;
    }

    public boolean isCheckGroundForFarmland() {
        return this.checkGroundForFarmland;
    }

    @Nonnull
    public CustomSeedFarmer setCheckGroundForFarmland(boolean checkGroundForFarmland) {
        this.checkGroundForFarmland = checkGroundForFarmland;
        return this;
    }

    public int getPlantedBlockMeta() {
        return this.plantedBlockMeta;
    }

    @Nonnull
    public Block getPlantedBlock() {
        return this.plantedBlock;
    }

    @Nonnull
    public ItemStack getSeeds() {
        return this.seeds;
    }

    public int getFullyGrownBlockMeta() {
        return this.grownBlockMeta;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState bs) {
        int meta = bs.func_177230_c().func_176201_c(bs);
        return block == this.getPlantedBlock() && this.getFullyGrownBlockMeta() == meta;
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        return Prep.isValid(stack) && stack.func_77969_a(this.getSeeds());
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        if (!farm.hasSeed(this.getSeeds(), bc)) {
            return false;
        }
        if (this.requiresTilling() && !this.isGroundTilled(farm, bc) && !farm.tillBlock(bc)) {
            return false;
        }
        return this.plantFromInventory(farm, bc);
    }

    public boolean requiresTilling() {
        return this.requiresTilling;
    }

    @Nonnull
    public CustomSeedFarmer setRequiresTilling(boolean requiresFarmland) {
        this.requiresTilling = requiresFarmland;
        return this;
    }

    protected boolean plantFromInventory(@Nonnull IFarmer farm, @Nonnull BlockPos bc) {
        World world = farm.getWorld();
        if (this.canPlant(farm, world, bc) && Prep.isValid(farm.takeSeedFromSupplies(bc))) {
            return this.plant(farm, world, bc);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, final @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull IBlockState state) {
        if (!this.canHarvest(farm, pos, block, state)) {
            return null;
        }
        if (!farm.hasTool(FarmingTool.HOE)) {
            farm.setNotification(FarmNotification.NO_HOE);
            return null;
        }
        final World world = farm.getWorld();
        FakePlayer joe = farm.startUsingItem(FarmingTool.HOE);
        int fortune = farm.getLootingValue(FarmingTool.HOE);
        final NNList result = new NNList();
        NNList drops = new NNList();
        block.getDrops((NonNullList)drops, (IBlockAccess)world, pos, state, fortune);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)joe.field_70170_p, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)joe);
        farm.registerAction(FarmingAction.HARVEST, FarmingTool.HOE, state, pos);
        boolean removed = false;
        for (ItemStack stack : drops) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            if (!removed && stack.func_77969_a(this.getSeeds())) {
                stack.func_190918_g(1);
                removed = true;
                if (!Prep.isValid(stack)) continue;
                result.add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l()));
                continue;
            }
            result.add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l()));
        }
        NNList.wrap(farm.endUsingItem(FarmingTool.HOE)).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                result.add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop.func_77946_l()));
            }
        });
        if (removed) {
            if (!this.plant(farm, world, pos)) {
                result.add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.getSeeds().func_77946_l()));
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        return new HarvestResult((NNList<EntityItem>)result, pos);
    }

    protected boolean isGroundTilled(@Nonnull IFarmer farm, @Nonnull BlockPos plantingLocation) {
        return this.tilledBlocks.contains(farm.getBlockState(plantingLocation.func_177977_b()).func_177230_c());
    }

    protected boolean canPlant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc) {
        Block target = this.getPlantedBlock();
        BlockPos groundPos = bc.func_177977_b();
        IBlockState bs = world.func_180495_p(groundPos);
        Block ground = bs.func_177230_c();
        IPlantable plantable = (IPlantable)this.getPlantedBlock();
        return !(!target.func_176196_c(world, bc) || !ground.canSustainPlant(bs, (IBlockAccess)world, groundPos, EnumFacing.UP, plantable) && !this.ignoreSustainCheck || this.isCheckGroundForFarmland() && !this.isGroundTilled(farm, bc));
    }

    protected boolean plant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc) {
        world.func_180501_a(bc, Blocks.field_150350_a.func_176223_P(), 3);
        if (this.canPlant(farm, world, bc)) {
            world.func_180501_a(bc, this.getPlantedBlock().func_176203_a(this.getPlantedBlockMeta()), 3);
            farm.registerAction(FarmingAction.PLANT, FarmingTool.HOE, Blocks.field_150350_a.func_176223_P(), bc);
            return true;
        }
        return false;
    }

    public boolean doesDisableTreeFarm() {
        return this.disableTreeFarm;
    }
}

