/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.CustomSeedFarmer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CocoaFarmer
extends CustomSeedFarmer {
    public CocoaFarmer() {
        super(Blocks.field_150375_by, new ItemStack(Items.field_151100_aR, 1, 3));
        this.requiresTilling = false;
        this.disableTreeFarm = true;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState meta) {
        return block == this.getPlantedBlock() && (Integer)meta.func_177229_b((IProperty)BlockCocoa.field_176501_a) == 2;
    }

    @Override
    protected boolean plant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc) {
        EnumFacing dir = this.getPlantDirection(world, bc);
        if (dir == null) {
            return false;
        }
        IBlockState iBlockState = this.getPlantedBlock().func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)dir);
        if (world.func_180501_a(bc, iBlockState, 3)) {
            farm.registerAction(FarmingAction.PLANT, FarmingTool.HAND, iBlockState, bc);
            return true;
        }
        return false;
    }

    @Override
    protected boolean canPlant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc) {
        return this.getPlantDirection(world, bc) != null;
    }

    @Nullable
    private EnumFacing getPlantDirection(@Nonnull World world, @Nonnull BlockPos bc) {
        if (!world.func_175623_d(bc)) {
            return null;
        }
        for (EnumFacing dir : NNList.FACING_HORIZONTAL) {
            BlockPos p = bc.func_177972_a(dir);
            if (!this.validBlock(world.func_180495_p(p))) continue;
            return dir;
        }
        return null;
    }

    private boolean validBlock(@Nonnull IBlockState iblockstate) {
        return iblockstate.func_177230_c() == Blocks.field_150364_r && iblockstate.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE;
    }
}

