/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ChorusFarmer
extends IForgeRegistryEntry.Impl<IFarmerJoe>
implements IFarmerJoe {
    @Nonnull
    private final Item flowerItem = Item.func_150898_a((Block)Blocks.field_185766_cS);
    @Nonnull
    private static final NNList<EnumFacing> GROW_DIRECTIONS = new NNList((Object[])new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST});

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        return stack.func_77973_b() == this.flowerItem;
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull IBlockState state) {
        ItemStack seed = farm.getSeedTypeInSuppliesFor(pos);
        FakePlayer player = farm.getFakePlayer();
        World world = farm.getWorld();
        if (this.canPlant(seed) && this.isValidPlantingSpot(world, pos) && player.func_175151_a(pos, EnumFacing.UP, seed) && world.func_190527_a(Blocks.field_185766_cS, pos, false, EnumFacing.UP, (Entity)null)) {
            IBlockState iblockstate1 = Blocks.field_185766_cS.func_176223_P().func_177226_a((IProperty)BlockChorusFlower.field_185607_a, (Comparable)Integer.valueOf(0));
            IBlockState oldState = world.func_180495_p(pos);
            if (this.placeBlockAt(seed, (EntityPlayer)player, world, pos, iblockstate1)) {
                if (Prep.isValid(farm.takeSeedFromSupplies(pos))) {
                    SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                    world.func_184133_a((EntityPlayer)player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    return true;
                }
                world.func_180501_a(pos, oldState, 3);
            }
        }
        return false;
    }

    private boolean isValidPlantingSpot(@Nonnull World world, @Nonnull BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (world.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == newState.func_177230_c()) {
            state.func_177230_c().func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState state) {
        return state.func_177230_c() == Blocks.field_185765_cR || state.func_177230_c() == Blocks.field_185766_cS;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState state) {
        BlockPos remove;
        if (!farm.hasTool(FarmingTool.AXE)) {
            farm.setNotification(FarmNotification.NO_AXE);
            return null;
        }
        ChorusWalker walker = new ChorusWalker(farm, bc);
        if (walker.flowersToHarvest.isEmpty() && walker.stemsToHarvest.isEmpty()) {
            return null;
        }
        World world = farm.getWorld();
        int fortune = farm.getLootingValue(FarmingTool.AXE);
        HarvestResult result = new HarvestResult();
        while (!walker.flowersToHarvest.isEmpty() && farm.checkAction(FarmingAction.HARVEST, FarmingTool.AXE)) {
            remove = (BlockPos)walker.flowersToHarvest.remove(0);
            this.doHarvest(farm, world, farm.getBlockState(remove), remove, fortune, result);
        }
        while (!walker.stemsToHarvest.isEmpty() && farm.checkAction(FarmingAction.HARVEST, FarmingTool.AXE)) {
            remove = (BlockPos)walker.stemsToHarvest.remove(walker.stemsToHarvest.size() - 1);
            this.doHarvest(farm, world, farm.getBlockState(remove), remove, fortune, result);
        }
        return result.getDrops().isEmpty() && result.getHarvestedBlocks().isEmpty() ? null : result;
    }

    private void doHarvest(final @Nonnull IFarmer farm, final @Nonnull World world, @Nonnull IBlockState blockState, final @Nonnull BlockPos pos, int fortune, final @Nonnull HarvestResult result) {
        FakePlayer joe = farm.startUsingItem(FarmingTool.AXE);
        NNList drops = new NNList();
        blockState.func_177230_c().getDrops((NonNullList)drops, (IBlockAccess)world, pos, blockState, fortune);
        final float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)blockState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)joe);
        blockState.func_177230_c().func_180657_a(joe.field_70170_p, (EntityPlayer)joe, pos, blockState, null, joe.func_184614_ca());
        NNList.wrap((List)drops).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                if (farm.getWorld().field_73012_v.nextFloat() <= chance) {
                    result.getDrops().add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop.func_77946_l()));
                }
            }
        });
        NNList.wrap(farm.endUsingItem(FarmingTool.AXE)).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                result.getDrops().add((Object)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop.func_77946_l()));
            }
        });
        farm.registerAction(FarmingAction.HARVEST, FarmingTool.AXE, blockState, pos);
        world.func_175698_g(pos);
        result.getHarvestedBlocks().add((Object)pos);
    }

    private static class ChorusWalker {
        @Nonnull
        final NNList<BlockPos> flowersToHarvest = new NNList();
        @Nonnull
        final NNList<BlockPos> stemsToHarvest = new NNList();
        @Nonnull
        final IFarmer farm;

        ChorusWalker(@Nonnull IFarmer farm, @Nonnull BlockPos pos) {
            this.farm = farm;
            this.collect(pos, EnumFacing.DOWN);
        }

        boolean collect(@Nonnull BlockPos pos, @Nonnull EnumFacing from) {
            IBlockState state = this.farm.getWorld().func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_185765_cR) {
                boolean isNeeded = false;
                for (EnumFacing side : GROW_DIRECTIONS) {
                    if (side == from) continue;
                    isNeeded |= this.collect(pos.func_177972_a(side), side.func_176734_d());
                }
                if (!isNeeded) {
                    this.stemsToHarvest.add((Object)pos);
                }
                return isNeeded;
            }
            if (state.func_177230_c() == Blocks.field_185766_cS) {
                if ((Integer)state.func_177229_b((IProperty)BlockChorusFlower.field_185607_a) == 5) {
                    this.flowersToHarvest.add((Object)pos);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

