/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming;

import com.enderio.core.common.util.stackable.IProducer;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.farming.farmers.ChorusFarmer;
import crazypants.enderio.base.farming.farmers.CocoaFarmer;
import crazypants.enderio.base.farming.farmers.CustomSeedFarmer;
import crazypants.enderio.base.farming.farmers.FlowerPicker;
import crazypants.enderio.base.farming.farmers.MelonFarmer;
import crazypants.enderio.base.farming.farmers.PickableFarmer;
import crazypants.enderio.base.farming.farmers.PlantableFarmer;
import crazypants.enderio.base.farming.farmers.StemFarmer;
import crazypants.enderio.base.farming.farmers.TreeFarmer;
import crazypants.enderio.base.init.ModObject;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public final class FarmersRegistry {
    @Nonnull
    public static final Things slotItemsHoeTools = new Things().add(Items.field_151017_I).add(Items.field_151018_J).add(Items.field_151019_K).add(Items.field_151013_M).add(Items.field_151012_L).add(Config.farmHoes);
    @Nonnull
    public static final Things slotItemsAxeTools = new Things().add(Items.field_151053_p).add(Items.field_151049_t).add(Items.field_151036_c).add(Items.field_151006_E).add(Items.field_151056_x).add((IProducer)ModObject.itemDarkSteelAxe);
    @Nonnull
    public static final Things slotItemsExtraTools = new Things().add((Item)Items.field_151097_aZ).add((IProducer)ModObject.itemDarkSteelShears);
    @Nonnull
    public static final Things slotItemsSeeds = new Things(new String[]{"treeSapling"}).add(Items.field_151014_N).add(Items.field_151172_bF).add(Items.field_151174_bG).add((Block)Blocks.field_150337_Q).add((Block)Blocks.field_150338_P).add(Items.field_151075_bm).add(Blocks.field_150345_g).add(Items.field_151120_aE).add(Items.field_151081_bc).add(Items.field_151080_bb);
    @Nonnull
    public static final Things slotItemsProduce = new Things(new String[]{"logWood"}).add(new ItemStack(Blocks.field_150364_r, 1, 0)).add(Blocks.field_150464_aj).add(new ItemStack((Block)Blocks.field_150362_t, 1, 0)).add(Items.field_151034_e).add(Items.field_151127_ba).add(Blocks.field_150423_aK).add((Block)Blocks.field_150327_N).add((Block)Blocks.field_150328_O);
    @Nonnull
    private static final Things SAPLINGS = new Things(new String[]{"treeSapling"});
    @Nonnull
    private static final Things WOODS = new Things(new String[]{"logWood"});
    @Nonnull
    private static final Things FLOWERS = new Things().add((Block)Blocks.field_150327_N).add((Block)Blocks.field_150328_O);

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerFarmers(@Nonnull RegistryEvent.Register<IFarmerJoe> event) {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerFarmersLow(@Nonnull RegistryEvent.Register<IFarmerJoe> event) {
        event.getRegistry().register(new FlowerPicker(FLOWERS).setRegistryName("enderio", "flowers"));
        event.getRegistry().register(new StemFarmer((Block)Blocks.field_150436_aH, new ItemStack(Items.field_151120_aE)).setRegistryName("enderio", "reeds"));
        event.getRegistry().register(new StemFarmer((Block)Blocks.field_150434_aF, new ItemStack((Block)Blocks.field_150434_aF)).setRegistryName("enderio", "cactus"));
        event.getRegistry().register(new TreeFarmer(SAPLINGS, WOODS).setRegistryName("enderio", "trees"));
        event.getRegistry().register(new TreeFarmer(true, (Block)Blocks.field_150337_Q, Blocks.field_150419_aX).setRegistryName("enderio", "red_mushrooms"));
        event.getRegistry().register(new TreeFarmer(true, (Block)Blocks.field_150338_P, Blocks.field_150420_aW).setRegistryName("enderio", "brown_mushrooms"));
        event.getRegistry().register(new MelonFarmer(Blocks.field_150394_bc, Blocks.field_150440_ba, new ItemStack(Items.field_151081_bc)).setRegistryName("enderio", "melons"));
        event.getRegistry().register(new MelonFarmer(Blocks.field_150393_bb, Blocks.field_150423_aK, new ItemStack(Items.field_151080_bb)).setRegistryName("enderio", "pumpkins"));
        event.getRegistry().register(new CustomSeedFarmer(Blocks.field_150388_bm, 3, new ItemStack(Items.field_151075_bm)).setRequiresTilling(false).setRegistryName("enderio", "netherwart"));
        event.getRegistry().register(new CocoaFarmer().setRegistryName("enderio", "cocoa"));
        event.getRegistry().register(new ChorusFarmer().setRegistryName("enderio", "chorus"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerFarmersLowest(@Nonnull RegistryEvent.Register<IFarmerJoe> event) {
        event.getRegistry().register(new PlantableFarmer().setRegistryName("enderio", "default"));
    }

    public static void addPickable(@Nonnull RegistryEvent.Register<IFarmerJoe> event, @Nonnull String mod, @Nonnull String blockName, @Nonnull String itemName) {
        Block cropBlock = FarmersRegistry.findBlock(mod, blockName);
        Item seedItem = FarmersRegistry.findItem(mod, itemName);
        if (cropBlock != null && seedItem != null) {
            event.getRegistry().register(new PickableFarmer(cropBlock, new ItemStack(seedItem)).setRegistryName(mod, blockName));
        }
    }

    public static CustomSeedFarmer addSeed(@Nonnull RegistryEvent.Register<IFarmerJoe> event, @Nonnull String mod, @Nonnull String blockName, @Nonnull String itemName, Block ... extraFarmland) {
        Block cropBlock = FarmersRegistry.findBlock(mod, blockName);
        Item seedItem = FarmersRegistry.findItem(mod, itemName);
        if (cropBlock != null && seedItem != null) {
            CustomSeedFarmer farmer = new CustomSeedFarmer(cropBlock, new ItemStack(seedItem));
            if (extraFarmland != null) {
                for (Block farmland : extraFarmland) {
                    if (farmland == null) continue;
                    farmer.addTilledBlock(farmland);
                }
            }
            event.getRegistry().register(farmer.setRegistryName(mod, blockName));
            return farmer;
        }
        return null;
    }

    public static Block findBlock(@Nonnull String mod, @Nonnull String blockName) {
        ResourceLocation name = new ResourceLocation(mod, blockName);
        if (Block.field_149771_c.func_148741_d((Object)name)) {
            return (Block)Block.field_149771_c.func_82594_a((Object)name);
        }
        return null;
    }

    public static Item findItem(@Nonnull String mod, @Nonnull String itemName) {
        ResourceLocation name = new ResourceLocation(mod, itemName);
        if (Item.field_150901_e.func_148741_d((Object)name)) {
            return (Item)Item.field_150901_e.func_82594_a((Object)name);
        }
        return null;
    }

    public static void registerFlower(String ... names) {
        for (String name : names) {
            FLOWERS.add(name);
        }
    }

    public static void registerSaplings(String ... names) {
        for (String name : names) {
            SAPLINGS.add(name);
        }
    }

    public static void registerLogs(String ... names) {
        for (String name : names) {
            WOODS.add(name);
        }
    }

    public static boolean isLog(Block block) {
        return WOODS.contains(block);
    }

    public static boolean isLog(Item item) {
        return WOODS.contains(item);
    }

    public static boolean isLog(ItemStack stack) {
        return WOODS.contains(stack);
    }

    private FarmersRegistry() {
    }
}

