/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeRoot;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Alias;
import crazypants.enderio.base.config.recipes.xml.Grindingball;
import crazypants.enderio.base.config.recipes.xml.Recipe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Recipes
implements RecipeRoot {
    private List<Alias> aliases;
    @Nonnull
    private final List<AbstractConditional> recipes = new ArrayList<AbstractConditional>();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        return this;
    }

    @Override
    public boolean isValid() {
        return !this.recipes.isEmpty() || this.aliases != null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void register(@Nonnull String recipeName) {
        Log.debug("Starting registering XML recipes");
        for (AbstractConditional recipe : this.recipes) {
            recipe.register((recipeName.isEmpty() ? "" : recipeName + ": ") + recipe.getName());
        }
        Log.debug("Done registering XML recipes");
    }

    @Override
    public <T extends RecipeRoot> T addRecipes(RecipeRoot other, boolean allowOverrides) throws InvalidRecipeConfigException {
        if (other instanceof Recipes) {
            if (!this.isValid()) {
                return (T)other;
            }
            if (!((Recipes)other).recipes.isEmpty()) {
                if (!this.recipes.isEmpty()) {
                    HashSet<String> recipeNames = new HashSet<String>();
                    for (AbstractConditional recipe : this.recipes) {
                        recipeNames.add(recipe.getName());
                    }
                    for (AbstractConditional recipe : ((Recipes)other).recipes) {
                        if (!recipeNames.contains(recipe.getName())) {
                            this.recipes.add(recipe);
                            continue;
                        }
                        if (allowOverrides) continue;
                        throw new InvalidRecipeConfigException("Duplicate recipe '" + recipe.getName() + "'");
                    }
                } else {
                    this.recipes.addAll(((Recipes)other).recipes);
                }
            }
        }
        return (T)this;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("enderio".equals(name)) {
            return true;
        }
        if ("xsi".equals(name)) {
            return true;
        }
        return "schemaLocation".equals(name);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("alias".equals(name)) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<Alias>();
            }
            this.aliases.add(factory.read(new Alias(), startElement));
            return true;
        }
        if ("recipe".equals(name)) {
            this.addRecipe(new Recipe(), factory, startElement);
            return true;
        }
        if ("grindingball".equals(name)) {
            this.addRecipe(new Grindingball(), factory, startElement);
            return true;
        }
        return false;
    }

    private <T extends AbstractConditional> void addRecipe(T element, StaxFactory factory, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        T recipe = factory.read(element, startElement);
        for (AbstractConditional existingRecipe : this.recipes) {
            if (!existingRecipe.getName().equals(recipe.getName())) continue;
            throw new InvalidRecipeConfigException("Duplicate recipe " + recipe.getName());
        }
        this.recipes.add(recipe);
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (AbstractConditional recipe : this.recipes) {
            recipe.enforceValidity();
        }
    }

    @Override
    public <T extends RecipeRoot> T copy(T in) {
        if (in instanceof Recipes) {
            Recipes result = new Recipes();
            if (this.aliases != null) {
                result.aliases = new ArrayList<Alias>(this.aliases);
            }
            result.recipes.addAll(this.recipes);
            return (T)result;
        }
        return null;
    }
}

