/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeConfigElement;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.ItemOptional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class ConditionDependency
implements RecipeConfigElement {
    private String itemString;
    private boolean reverse;
    private transient ItemOptional item;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            if (this.itemString == null || this.itemString.trim().isEmpty()) {
                throw new InvalidRecipeConfigException("Missing item");
            }
            this.item = new ItemOptional().setAllowDelaying(false);
            this.item.setName(this.itemString);
            this.item.readResolve();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <dependency>");
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.item.isValid() != this.reverse;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name)) {
            this.itemString = value;
            return true;
        }
        if ("reverse".equals(name)) {
            this.reverse = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
    }
}

