/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeGameRecipe;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.ConditionConfig;
import crazypants.enderio.base.config.recipes.xml.ConditionDependency;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class AbstractConditional
implements RecipeGameRecipe {
    private List<ConditionConfig> configReferences;
    private List<ConditionDependency> dependencies;
    protected transient boolean valid;
    protected transient boolean active;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        this.active = true;
        if (this.configReferences != null) {
            for (ConditionConfig configReference : this.configReferences) {
                if (configReference.isValid()) continue;
                this.active = false;
            }
        }
        if (this.dependencies != null) {
            for (ConditionDependency dependency : this.dependencies) {
                if (dependency.isValid()) continue;
                this.active = false;
            }
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("config".equals(name)) {
            if (this.configReferences == null) {
                this.configReferences = new ArrayList<ConditionConfig>();
            }
            this.configReferences.add(factory.read(new ConditionConfig(), startElement));
            return true;
        }
        if ("dependency".equals(name)) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<ConditionDependency>();
            }
            this.dependencies.add(factory.read(new ConditionDependency(), startElement));
            return true;
        }
        return false;
    }
}

