/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeFactory;
import crazypants.enderio.base.config.recipes.xml.Recipes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;

public class RecipeLoader {
    private static NNList<String> imcRecipes = new NNList();

    private RecipeLoader() {
    }

    public static void addRecipes() {
        RecipeFactory recipeFactory = new RecipeFactory(Config.getConfigDirectory(), "enderio");
        recipeFactory.createFolder("recipes");
        recipeFactory.createFolder("recipes/user");
        recipeFactory.createFolder("recipes/examples");
        recipeFactory.placeXSD("recipes");
        recipeFactory.placeXSD("recipes/user");
        recipeFactory.placeXSD("recipes/examples");
        recipeFactory.createFileUser("recipes/user/user_recipes.xml");
        NNList recipeFiles = new NNList();
        for (ModContainer modContainer : Loader.instance().getModList()) {
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon)) continue;
            recipeFiles.addAll(((IEnderIOAddon)mod).getRecipeFiles());
            for (String filename : ((IEnderIOAddon)mod).getExampleFiles()) {
                recipeFactory.copyCore("recipes/examples/" + filename + ".xml");
            }
        }
        Collections.sort(recipeFiles, new Comparator<Triple<Integer, RecipeFactory, String>>(){

            @Override
            public int compare(Triple<Integer, RecipeFactory, String> o1, Triple<Integer, RecipeFactory, String> o2) {
                return ((Integer)o1.getLeft()).compareTo((Integer)o2.getLeft());
            }
        });
        HashSet<File> userfiles = new HashSet<File>((Collection<File>)recipeFactory.listXMLFiles("recipes/user"));
        for (Triple triple : recipeFiles) {
            RecipeFactory factory = (RecipeFactory)triple.getMiddle();
            if (factory == null) continue;
            userfiles.addAll((Collection<File>)factory.listXMLFiles("recipes/user"));
        }
        Recipes config = new Recipes();
        if (RecipeConfig.loadCoreRecipes.get().booleanValue()) {
            try {
                for (Triple triple : recipeFiles) {
                    config = (Recipes)RecipeLoader.readCoreFile((RecipeFactory)NullHelper.first((Object[])new RecipeFactory[]{(RecipeFactory)triple.getMiddle(), recipeFactory}), "recipes/" + (String)triple.getRight()).addRecipes(config, false);
                }
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), "Core Recipes"}), e.getMessage());
            }
        }
        if (imcRecipes != null) {
            config = RecipeLoader.handleIMCRecipes(config);
            imcRecipes = null;
        }
        for (File file : userfiles) {
            Recipes userFile = RecipeLoader.readUserFile(recipeFactory, file.getName(), file);
            if (userFile == null) continue;
            try {
                config = (Recipes)userFile.addRecipes(config, true);
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), file.getName()}), e.getMessage());
            }
        }
        config.register("");
        for (ModContainer modContainer : Loader.instance().getModList()) {
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon)) continue;
            ((IEnderIOAddon)mod).postRecipeRegistration();
        }
    }

    private static Recipes handleIMCRecipes(Recipes config) {
        for (String recipe : imcRecipes) {
            try {
                InputStream is = IOUtils.toInputStream((String)recipe, (Charset)Charset.forName("UTF-8"));
                Throwable throwable = null;
                try {
                    Recipes recipes = RecipeFactory.readStax(new Recipes(), "recipes", is);
                    recipes.enforceValidity();
                    config = (Recipes)recipes.addRecipes(config, true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), "IMC from other mod"}), e.getMessage());
            }
            catch (IOException e) {
                Log.error("IO error while parsing string:");
                e.printStackTrace();
                RecipeLoader.recipeError("IMC from other mod", "IO error while parsing string:" + e.getMessage());
            }
            catch (XMLStreamException e) {
                Log.error("IMC has malformed XML:");
                e.printStackTrace();
                RecipeLoader.recipeError("IMC from other mod", "IMC has malformed XML:" + e.getMessage());
            }
        }
        return config;
    }

    private static Recipes readUserFile(RecipeFactory recipeFactory, String filename, File file) {
        try {
            Recipes recipes = RecipeFactory.readFileUser(new Recipes(), "recipes", filename, file);
            if (recipes.isValid()) {
                recipes.enforceValidity();
                return recipes;
            }
        }
        catch (InvalidRecipeConfigException e) {
            RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), filename}), e.getMessage());
        }
        catch (IOException e) {
            Log.error("IO error while reading file:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename, "IO error while reading file:" + e.getMessage());
        }
        catch (XMLStreamException e) {
            Log.error("File has malformed XML:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename, "File has malformed XML:" + e.getMessage());
        }
        return null;
    }

    private static Recipes readCoreFile(RecipeFactory recipeFactory, String filename) {
        try {
            Recipes recipes = recipeFactory.readCoreFile(new Recipes(), "recipes", filename + ".xml");
            if (recipes.isValid()) {
                recipes.enforceValidity();
                return recipes;
            }
            RecipeLoader.recipeError(filename, "File is empty or invalid");
        }
        catch (InvalidRecipeConfigException e) {
            RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), filename + ".xml"}), e.getMessage());
        }
        catch (IOException e) {
            Log.error("IO error while reading file:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename + ".xml", "IO error while reading file:" + e.getMessage());
        }
        catch (XMLStreamException e) {
            Log.error("File has malformed XML:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename + ".xml", "File has malformed XML:" + e.getMessage());
        }
        return new Recipes();
    }

    public static void addIMCRecipe(String recipe) throws XMLStreamException, IOException {
        if (imcRecipes != null) {
            imcRecipes.add((Object)recipe);
        } else {
            try (InputStream is = IOUtils.toInputStream((String)recipe, (Charset)Charset.forName("UTF-8"));){
                Recipes recipes = RecipeFactory.readStax(new Recipes(), "recipes", is);
                recipes.enforceValidity();
                recipes.register("IMC recipes");
                return;
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError(recipe + " (IMC from other mod)", e.getMessage());
            }
            catch (IOException e) {
                Log.error("IO error while parsing string:");
                e.printStackTrace();
                RecipeLoader.recipeError("IMC from other mod", "IO error while parsing string:" + e.getMessage());
            }
            catch (XMLStreamException e) {
                Log.error("IMC has malformed XML:");
                e.printStackTrace();
                RecipeLoader.recipeError("IMC from other mod", "IMC has malformed XML:" + e.getMessage());
            }
        }
    }

    private static void recipeError(String filename, String message) {
        EnderIO.proxy.stopWithErrorScreen("=======================================================================", "== ENDER IO FATAL ERROR ==", "=======================================================================", "Cannot register recipes as configured. This means that either", "your custom config file has an error or another mod does bad", "things to vanilla items or the Ore Dictionary.", "=======================================================================", "== Bad file ==", filename, "=======================================================================", "== Error Message ==", message, "=======================================================================", "", "=======================================================================", "Note: To start the game anyway, you can disable recipe loading in the", "Ender IO config file. However, then all of Ender IO's crafting recipes", "will be missing.", "=======================================================================");
    }
}

