/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.factory.AbstractValue;
import crazypants.enderio.base.config.factory.IRootFactory;
import crazypants.enderio.base.config.factory.IValueFactory;
import crazypants.enderio.base.config.factory.SlaveFactory;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public class ValueFactory
implements IRootFactory {
    @Nonnull
    private final String modid;
    private Configuration config = null;
    private boolean inInit = false;
    private int generation = 0;
    @Nonnull
    private final NNList<AbstractValue<?>> preloadValues = new NNList();

    public ValueFactory(@Nonnull String modid) {
        this.modid = modid;
    }

    @Override
    @Nonnull
    public IValueFactory section(@Nonnull String section) {
        return new SlaveFactory(this, section);
    }

    @Override
    @Nonnull
    public String getModid() {
        return this.modid;
    }

    @Override
    @Nonnull
    public String getSection() {
        return "";
    }

    public void setConfig(Configuration config) {
        this.config = config;
        ++this.generation;
        this.inInit = true;
        for (AbstractValue value : this.preloadValues) {
            value.get();
        }
        this.inInit = false;
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public boolean isInInit() {
        return this.inInit;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void addPreloadValue(@Nonnull AbstractValue<?> value) {
        this.preloadValues.add(value);
    }
}

