/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.factory.AbstractValue;
import crazypants.enderio.base.config.factory.BooleanValue;
import crazypants.enderio.base.config.factory.ByteBufHelper;
import crazypants.enderio.base.config.factory.DoubleValue;
import crazypants.enderio.base.config.factory.FactoryManager;
import crazypants.enderio.base.config.factory.FloatValue;
import crazypants.enderio.base.config.factory.FluidValue;
import crazypants.enderio.base.config.factory.IRootFactory;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.config.factory.IValueFactory;
import crazypants.enderio.base.config.factory.IntValue;
import crazypants.enderio.base.config.factory.StringValue;
import crazypants.enderio.base.config.factory.ThingsValue;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;

public class SlaveFactory
implements IValueFactory {
    @Nonnull
    private final String section;
    @Nonnull
    private final IRootFactory parent;
    private Map<String, Object> serverConfig = null;
    private int generation = 0;
    @Nonnull
    private final NNList<AbstractValue<?>> syncValues = new NNList();

    public SlaveFactory(@Nonnull IRootFactory valueFactory, @Nonnull String section) {
        this.parent = valueFactory;
        this.section = section;
        FactoryManager.registerFactory(this);
    }

    @Override
    @Nonnull
    public IValueFactory section(@Nonnull String section) {
        if (section.startsWith(".")) {
            return new SlaveFactory(this, this.section + section);
        }
        return new SlaveFactory(this, section);
    }

    @Override
    public boolean isServerOverrideInPlace() {
        return this.serverConfig != null;
    }

    @Override
    @Nonnull
    public String getModid() {
        return this.parent.getModid();
    }

    @Override
    @Nonnull
    public String getSection() {
        return this.section;
    }

    @Override
    @Nonnull
    public IValue<Integer> make(@Nonnull String keyname, int defaultValue, @Nonnull String text) {
        return new IntValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<Double> make(@Nonnull String keyname, double defaultValue, @Nonnull String text) {
        return new DoubleValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<Float> make(@Nonnull String keyname, float defaultValue, @Nonnull String text) {
        return new FloatValue((IValueFactory)this, this.section, keyname, Float.valueOf(defaultValue), text).preload();
    }

    @Override
    @Nonnull
    public IValue<String> make(@Nonnull String keyname, @Nonnull String defaultValue, @Nonnull String text) {
        return new StringValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<Boolean> make(@Nonnull String keyname, @Nonnull Boolean defaultValue, @Nonnull String text) {
        return new BooleanValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<Things> make(@Nonnull String keyname, @Nonnull Things defaultValue, @Nonnull String text) {
        return new ThingsValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    @Nonnull
    public IValue<Fluid> makeFluid(@Nonnull String keyname, @Nonnull String defaultValue, @Nonnull String text) {
        return new FluidValue((IValueFactory)this, this.section, keyname, defaultValue, text).preload();
    }

    @Override
    public synchronized int read(ByteBuf buf) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (ByteBufHelper.ENDMARKER.readValue(buf) == null) {
            String keyName = (String)ByteBufHelper.STRING127.readValue(buf);
            byte dataTypeByte = buf.readByte();
            ByteBufHelper dataType = ByteBufHelper.values()[dataTypeByte];
            Object readValue = dataType.readValue(buf);
            result.put(keyName, readValue);
        }
        this.serverConfig = result;
        ++this.generation;
        return result.size();
    }

    @Override
    public void save(ByteBuf buf) {
        for (AbstractValue value : this.syncValues) {
            value.save(buf);
        }
        ByteBufHelper.ENDMARKER.saveValue(buf, this);
    }

    @Override
    public void endServerOverride() {
        this.serverConfig = null;
        ++this.generation;
    }

    @Override
    public Configuration getConfig() {
        return this.parent.getConfig();
    }

    @Override
    public boolean isInInit() {
        return this.parent.isInInit();
    }

    @Override
    public Map<String, Object> getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public int getGeneration() {
        return 31 * (31 + this.parent.getGeneration()) + this.generation;
    }

    @Override
    public void addSyncValue(@Nonnull AbstractValue<?> value) {
        this.syncValues.add(value);
    }

    @Override
    public void addPreloadValue(@Nonnull AbstractValue<?> value) {
        this.parent.addPreloadValue(value);
    }
}

