/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.factory.ByteBufHelper;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.config.factory.IValueFactory;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractValue<T>
implements IValue<T> {
    @Nonnull
    protected final IValueFactory owner;
    protected int valueGeneration = 0;
    @Nonnull
    protected final String section;
    @Nonnull
    protected final String keyname;
    @Nonnull
    private final String text;
    @Nonnull
    protected final T defaultValue;
    @Nullable
    protected T value = null;
    protected Double minValue;
    protected Double maxValue;
    private boolean isSynced = false;

    protected AbstractValue(@Nonnull IValueFactory owner, @Nonnull String section, @Nonnull String keyname, @Nonnull T defaultValue, @Nonnull String text) {
        this.owner = owner;
        this.section = section;
        this.keyname = keyname;
        this.text = text;
        this.defaultValue = defaultValue;
    }

    @Override
    @Nonnull
    public T get() {
        if (this.value == null || this.valueGeneration != this.owner.getGeneration()) {
            if (this.owner.getServerConfig() != null && this.owner.getServerConfig().containsKey(this.keyname)) {
                try {
                    this.value = this.owner.getServerConfig().get(this.keyname);
                }
                catch (ClassCastException e) {
                    Log.error("Server config value " + this.keyname + " is invalid");
                    this.value = null;
                }
            } else {
                this.value = this.makeValue();
                if (!this.owner.isInInit() && this.owner.getConfig().hasChanged()) {
                    this.owner.getConfig().save();
                }
            }
            this.valueGeneration = this.owner.getGeneration();
        }
        return (T)NullHelper.first((Object[])new Object[]{this.value, this.defaultValue});
    }

    @Nullable
    protected abstract T makeValue();

    @Override
    @Nonnull
    public IValue<T> setMin(double min) {
        this.minValue = min;
        return this;
    }

    @Override
    @Nonnull
    public IValue<T> setMax(double max) {
        this.maxValue = max;
        return this;
    }

    @Override
    @Nonnull
    public IValue<T> sync() {
        this.isSynced = true;
        this.owner.addSyncValue(this);
        return this;
    }

    @Nonnull
    public IValue<T> preload() {
        this.owner.addPreloadValue(this);
        return this;
    }

    public void save(ByteBuf buf) {
        ByteBufHelper.STRING127.saveValue(buf, this.keyname);
        ByteBufHelper dataType = this.getDataType();
        buf.writeByte(dataType.ordinal());
        dataType.saveValue(buf, this.get());
    }

    protected abstract ByteBufHelper getDataType();

    protected String getText() {
        return this.text + (this.isSynced ? " (synced from server)" : "");
    }
}

