/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config;

import com.enderio.core.common.event.ConfigFileChangedEvent;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.config.PacketConfigSync;
import crazypants.enderio.base.config.config.BaseConfig;
import crazypants.enderio.base.network.PacketHandler;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class Config {
    public static Configuration config;
    @Nonnull
    public static final Section sectionPower;
    @Nonnull
    public static final Section sectionRecipe;
    @Nonnull
    public static final Section sectionItems;
    @Nonnull
    public static final Section sectionEfficiency;
    @Nonnull
    public static final Section sectionAnchor;
    @Nonnull
    public static final Section sectionStaff;
    @Nonnull
    public static final Section sectionRod;
    @Nonnull
    public static final Section sectionDarkSteel;
    @Nonnull
    public static final Section sectionAdvanced;
    @Nonnull
    public static final Section sectionMagnet;
    @Nonnull
    public static final Section sectionFluid;
    @Nonnull
    public static final Section sectionSoulBinder;
    @Nonnull
    public static final Section sectionSoulVial;
    @Nonnull
    public static final Section sectionEnchantments;
    @Nonnull
    public static final Section sectionMisc;
    @Nonnull
    public static final Section sectionCapacitor;
    @Nonnull
    public static final Section sectionHoes;
    public static final double DEFAULT_CONDUIT_SCALE = 0.6;
    public static final float EXPLOSION_RESISTANT = 1200.0f;
    public static double conduitScale;
    public static File configDirectory;
    public static int travelAnchorMaximumDistance;
    public static int travelAnchorCooldown;
    public static boolean travelAnchorSneak;
    public static boolean travelAnchorSkipWarning;
    public static int travelStaffMaximumDistance;
    public static float travelStaffPowerPerBlockRF;
    public static int travelStaffMaxBlinkDistance;
    public static int travelStaffBlinkPauseTicks;
    public static boolean travelStaffBlinkEnabled;
    public static boolean travelStaffBlinkThroughSolidBlocksEnabled;
    public static boolean travelStaffBlinkThroughClearBlocksEnabled;
    public static boolean travelStaffBlinkThroughUnbreakableBlocksEnabled;
    public static String[] travelStaffBlinkBlackList;
    public static boolean travelStaffOffhandBlinkEnabled;
    public static boolean travelStaffOffhandTravelEnabled;
    public static boolean travelStaffOffhandShowsTravelTargets;
    public static float travelAnchorZoomScale;
    public static double[] darkSteelPowerDamgeAbsorptionRatios;
    public static int darkSteelPowerStorageBase;
    public static int darkSteelPowerStorageLevelOne;
    public static int darkSteelPowerStorageLevelTwo;
    public static int darkSteelPowerStorageLevelThree;
    public static int darkSteelSpeedOneCost;
    public static int darkSteelSpeedTwoCost;
    public static int darkSteelSpeedThreeCost;
    public static double darkSteelBootsJumpModifier;
    public static int darkSteelJumpOneCost;
    public static int darkSteelJumpTwoCost;
    public static int darkSteelJumpThreeCost;
    public static boolean slotZeroPlacesEight;
    public static int darkSteelWalkPowerCost;
    public static int darkSteelSprintPowerCost;
    public static boolean darkSteelDrainPowerFromInventory;
    public static int darkSteelBootsJumpPowerCost;
    public static int darkSteelFallDistanceCost;
    public static float darkSteelSwordWitherSkullChance;
    public static float darkSteelSwordWitherSkullLootingModifier;
    public static float darkSteelSwordSkullChance;
    public static float darkSteelSwordSkullLootingModifier;
    public static float vanillaSwordSkullLootingModifier;
    public static float vanillaSwordSkullChance;
    public static float ticCleaverSkullDropChance;
    public static float ticBeheadingSkullModifier;
    public static float fakePlayerSkullChance;
    public static int darkSteelSwordPowerUsePerHit;
    public static double darkSteelSwordEnderPearlDropChance;
    public static double darkSteelSwordEnderPearlDropChancePerLooting;
    public static float darkSteelBowDamageBonus;
    public static double[] darkSteelBowForceMultipliers;
    public static int[] darkSteelBowDrawSpeeds;
    public static double[] darkSteelBowFovMultipliers;
    public static int darkSteelBowPowerUsePerDamagePoint;
    public static int darkSteelBowPowerUsePerDraw;
    public static int darkSteelBowPowerUsePerTickDrawn;
    public static int darkSteelPickEffeciencyObsidian;
    public static int darkSteelPickPowerUseObsidian;
    public static float darkSteelPickApplyObsidianEffeciencyAtHardess;
    public static int darkSteelPickPowerUsePerDamagePoint;
    public static float darkSteelPickEffeciencyBoostWhenPowered;
    public static boolean darkSteelPickMinesTiCArdite;
    public static int darkSteelAxePowerUsePerDamagePoint;
    public static int darkSteelAxePowerUsePerDamagePointMultiHarvest;
    public static float darkSteelAxeEffeciencyBoostWhenPowered;
    public static float darkSteelAxeSpeedPenaltyMultiHarvest;
    public static int darkSteelShearsDurabilityFactor;
    public static int darkSteelShearsPowerUsePerDamagePoint;
    public static float darkSteelShearsEffeciencyBoostWhenPowered;
    public static int darkSteelShearsBlockAreaBoostWhenPowered;
    public static float darkSteelShearsEntityAreaBoostWhenPowered;
    public static int darkSteelUpgradeVibrantCost;
    public static int darkSteelUpgradePowerOneCost;
    public static int darkSteelUpgradePowerTwoCost;
    public static int darkSteelUpgradePowerThreeCost;
    public static int darkSteelGliderCost;
    public static double darkSteelGliderHorizontalSpeed;
    public static double darkSteelGliderVerticalSpeed;
    public static double darkSteelGliderVerticalSpeedSprinting;
    public static int darkSteelElytraCost;
    public static int darkSteelGogglesOfRevealingCost;
    public static int darkSteelSwimCost;
    public static int darkSteelNightVisionCost;
    public static int darkSteelTOPCost;
    public static int darkSteelSoundLocatorCost;
    public static int darkSteelSoundLocatorRange;
    public static int darkSteelSoundLocatorLifespan;
    public static int darkSteelTravelCost;
    public static int darkSteelSpoonCost;
    public static boolean darkSteelSolarChargeOthers;
    public static float darkSteelAnvilDamageChance;
    public static float darkSteelLadderSpeedBoost;
    public static int hootchPowerPerCycleRF;
    public static int hootchPowerTotalBurnTime;
    public static int rocketFuelPowerPerCycleRF;
    public static int rocketFuelPowerTotalBurnTime;
    public static int fireWaterPowerPerCycleRF;
    public static int fireWaterPowerTotalBurnTime;
    public static String[] hoeStrings;
    @Nonnull
    public static Things farmHoes;
    public static int magnetPowerUsePerSecondRF;
    public static int magnetPowerCapacityRF;
    public static int magnetRange;
    public static String[] magnetBlacklist;
    public static int magnetMaxItems;
    public static boolean magnetAllowInMainInventory;
    public static boolean magnetAllowInBaublesSlot;
    public static boolean magnetAllowDeactivatedInBaublesSlot;
    public static String magnetBaublesType;
    public static long nutrientFoodBoostDelay;
    public static boolean rocketFuelIsExplosive;
    public static double xpVacuumRange;
    public static NNList<ResourceLocation> soulVesselBlackList;
    public static NNList<ResourceLocation> soulVesselUnspawnableList;
    public static boolean soulVesselCapturesBosses;
    public static int soulBinderBrokenSpawnerRF;
    public static int soulBinderBrokenSpawnerLevels;
    public static int soulBinderReanimationRF;
    public static int soulBinderReanimationLevels;
    public static int soulBinderEnderCystalRF;
    public static int soulBinderEnderCystalLevels;
    public static int soulBinderPrecientCystalRF;
    public static int soulBinderPrecientCystalLevels;
    public static int soulBinderAttractorCystalRF;
    public static int soulBinderAttractorCystalLevels;
    public static int soulBinderTunedPressurePlateLevels;
    public static int soulBinderTunedPressurePlateRF;
    public static float slicenspliceToolDamageChance;
    public static int xpObeliskMaxXpLevel;
    public static boolean clearGlassConnectToFusedQuartz;
    public static boolean glassConnectToTheirVariants;
    public static boolean glassConnectToTheirColorVariants;
    public static Enchantment.Rarity enchantmentSoulBoundRarity;
    public static boolean rodOfReturnCanTargetAnywhere;
    public static int rodOfReturnTicksToActivate;
    public static int rodOfReturnPowerStorage;
    public static int rodOfReturnMinTicksToRecharge;
    public static int rodOfReturnRfPerTick;
    public static int rodOfReturnFluidUsePerTeleport;
    public static int rodOfReturnFluidStorage;
    public static String rodOfReturnFluidType;
    public static boolean paintedGlowstoneRequireSilkTouch;
    public static boolean enableBaublesIntegration;
    public static int maxMobsAttracted;
    public static double teleportEffectProbability;
    public static final Things TRAVEL_BLACKLIST;

    @Nonnull
    public static File getConfigDirectory() {
        return (File)NullHelper.notnull((Object)configDirectory, (String)"trying to access config before preInit");
    }

    public static void init(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new Config());
        configDirectory = new File(event.getModConfigurationDirectory(), "enderio");
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        File configFile = new File(configDirectory, "EnderIO.cfg");
        config = new Configuration(configFile);
        Config.syncConfig(false);
    }

    public static void syncConfig(boolean load) {
        try {
            if (load) {
                config.load();
            }
            Config.processConfig(config);
        }
        catch (Exception e) {
            Log.error("EnderIO has a problem loading it's configuration");
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("enderio")) {
            Log.info("Updating config...");
            Config.syncConfig(false);
            Config.init((FMLPostInitializationEvent)null);
        }
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.getModID().equals("enderio")) {
            Log.info("Updating config...");
            Config.syncConfig(true);
            event.setSuccessful();
            Config.init((FMLPostInitializationEvent)null);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketConfigSync(), (EntityPlayerMP)evt.player);
        if ("5.0.24".contains("-") || "5.0.24".contains("@")) {
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "This is an " + TextFormatting.BLACK + "Ender IO " + TextFormatting.DARK_RED + "development build!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "It may trash your world at any time!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Do not use it for anything but testing!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString("You have been warned..."));
        }
    }

    public static void processConfig(Configuration config) {
        conduitScale = config.get(Config.sectionMisc.name, "conduitScale", 0.6, "Valid values are between 0-1, smallest conduits at 0, largest at 1.\nIn SMP, all clients must be using the same value as the server.").getDouble(0.6);
        conduitScale = VecmathUtil.clamp((double)conduitScale, (double)0.0, (double)1.0);
        travelAnchorMaximumDistance = config.get(Config.sectionAnchor.name, "travelAnchorMaxDistance", travelAnchorMaximumDistance, "Maximum number of blocks that can be traveled from one travel anchor to another.").getInt(travelAnchorMaximumDistance);
        travelAnchorCooldown = config.get(Config.sectionAnchor.name, "travelAnchorCooldown", travelAnchorCooldown, "Number of ticks in cooldown between activations (1 sec = 20 ticks)").getInt(travelAnchorCooldown);
        travelAnchorSneak = config.get(Config.sectionAnchor.name, "travelAnchorSneak", travelAnchorSneak, "Add sneak as an option to activate travel anchors").getBoolean(travelAnchorSneak);
        travelAnchorSkipWarning = config.get(Config.sectionAnchor.name, "travelAnchorSkipWarning", travelAnchorSkipWarning, "Travel Anchors send a chat warning when skipping inaccessible anchors").getBoolean(travelAnchorSkipWarning);
        travelStaffMaximumDistance = config.get(Config.sectionStaff.name, "travelStaffMaxDistance", travelStaffMaximumDistance, "Maximum number of blocks that can be traveled using the Staff of Traveling.").getInt(travelStaffMaximumDistance);
        travelStaffPowerPerBlockRF = (float)config.get(Config.sectionStaff.name, "travelStaffPowerPerBlockRF", (double)travelStaffPowerPerBlockRF, "Amount of energy required per block traveled using the Staff of Traveling.").getDouble((double)travelStaffPowerPerBlockRF);
        travelStaffMaxBlinkDistance = config.get(Config.sectionStaff.name, "travelStaffMaxBlinkDistance", travelStaffMaxBlinkDistance, "Max number of blocks teleported when shift clicking the staff.").getInt(travelStaffMaxBlinkDistance);
        travelStaffBlinkPauseTicks = config.get(Config.sectionStaff.name, "travelStaffBlinkPauseTicks", travelStaffBlinkPauseTicks, "Minimum number of ticks between 'blinks'. Values of 10 or less allow a limited sort of flight.").getInt(travelStaffBlinkPauseTicks);
        travelStaffBlinkEnabled = config.get(Config.sectionStaff.name, "travelStaffBlinkEnabled", travelStaffBlinkEnabled, "If set to false: the travel staff can not be used to shift-right click teleport, or blink.").getBoolean(travelStaffBlinkEnabled);
        travelStaffBlinkThroughSolidBlocksEnabled = config.get(Config.sectionStaff.name, "travelStaffBlinkThroughSolidBlocksEnabled", travelStaffBlinkThroughSolidBlocksEnabled, "If set to false: the travel staff can be used to blink through any block.").getBoolean(travelStaffBlinkThroughSolidBlocksEnabled);
        travelStaffBlinkThroughClearBlocksEnabled = config.get(Config.sectionItems.name, "travelStaffBlinkThroughClearBlocksEnabled", travelStaffBlinkThroughClearBlocksEnabled, "If travelStaffBlinkThroughSolidBlocksEnabled is set to false and this is true: the travel staff can only be used to blink through transparent or partial blocks (e.g. torches). If both are false: only air blocks may be teleported through.").getBoolean(travelStaffBlinkThroughClearBlocksEnabled);
        travelStaffBlinkThroughUnbreakableBlocksEnabled = config.get(Config.sectionItems.name, "travelStaffBlinkThroughUnbreakableBlocksEnabled", travelStaffBlinkThroughUnbreakableBlocksEnabled, "Allows the travel staff to blink through unbreakable blocks such as warded blocks and bedrock.").getBoolean();
        travelStaffBlinkBlackList = config.getStringList("travelStaffBlinkBlackList", Config.sectionStaff.name, travelStaffBlinkBlackList, "Lists the blocks that cannot be teleported through in the form 'modID:blockName'");
        travelAnchorZoomScale = config.getFloat("travelAnchorZoomScale", Config.sectionStaff.name, travelAnchorZoomScale, 0.0f, 1.0f, "Set the max zoomed size of a travel anchor as an aprox. percentage of screen height");
        travelStaffOffhandBlinkEnabled = config.get(Config.sectionStaff.name, "travelStaffOffhandBlinkEnabled", travelStaffOffhandBlinkEnabled, "If set to false: the travel staff can not be used to shift-right click teleport, or blink, when held in the off-hand.").getBoolean(travelStaffOffhandBlinkEnabled);
        travelStaffOffhandTravelEnabled = config.get(Config.sectionStaff.name, "travelStaffOffhandTravelEnabled", travelStaffOffhandTravelEnabled, "If set to false: the travel staff can not be used to click teleport to Travel Anchors, when held in the off-hand.").getBoolean(travelStaffOffhandTravelEnabled);
        travelStaffOffhandShowsTravelTargets = config.get(Config.sectionStaff.name, "travelStaffOffhandShowsTravelTargets", travelStaffOffhandShowsTravelTargets, "If set to false: Teleportation targets will not be highlighted for travel items held in the off-hand.").getBoolean(travelStaffOffhandShowsTravelTargets);
        rodOfReturnCanTargetAnywhere = config.get(Config.sectionRod.name, "rodOfReturnCanTargetAnywhere", rodOfReturnCanTargetAnywhere, "If set to false the rod of return can only target a telepad.").getBoolean(rodOfReturnCanTargetAnywhere);
        rodOfReturnTicksToActivate = config.get(Config.sectionRod.name, "rodOfReturnTicksToActivate", rodOfReturnTicksToActivate, "Number of ticks the rod must be used before teleporting").getInt(rodOfReturnTicksToActivate);
        rodOfReturnPowerStorage = config.get(Config.sectionRod.name, "rodOfReturnPowerStorage", rodOfReturnPowerStorage, "Internal energy buffer for rod").getInt(rodOfReturnPowerStorage);
        rodOfReturnRfPerTick = config.get(Config.sectionRod.name, "rodOfReturnRfPerTick", rodOfReturnRfPerTick, "energy used per tick").getInt(rodOfReturnRfPerTick);
        rodOfReturnMinTicksToRecharge = config.get(Config.sectionRod.name, "rodOfReturnMinTicksToRecharge", rodOfReturnMinTicksToRecharge, "Min number of ticks required to recharge the internal energy buffer").getInt(rodOfReturnMinTicksToRecharge);
        rodOfReturnFluidStorage = config.get(Config.sectionRod.name, "rodOfReturnFluidStorage", rodOfReturnFluidStorage, "How much fluid the rod can store").getInt(rodOfReturnFluidStorage);
        rodOfReturnFluidUsePerTeleport = config.get(Config.sectionRod.name, "rodOfReturnFluidUsePerTeleport", rodOfReturnFluidUsePerTeleport, "How much fluid is used per teleport").getInt(rodOfReturnFluidUsePerTeleport);
        rodOfReturnFluidType = config.getString("rodOfReturnFluidType", Config.sectionRod.name, rodOfReturnFluidType, "The type of fluid used by the rod.");
        darkSteelPowerDamgeAbsorptionRatios = config.get(Config.sectionDarkSteel.name, "darkSteelPowerDamgeAbsorptionRatios", darkSteelPowerDamgeAbsorptionRatios, "A list of the amount of durability damage absorbed when items are powered. In order of upgrade level. 1=100% so items take no durability damage when powered.").getDoubleList();
        darkSteelPowerStorageBase = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorageBase", darkSteelPowerStorageBase, "Base amount of power stored by dark steel items.").getInt(darkSteelPowerStorageBase);
        darkSteelPowerStorageLevelOne = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorageLevelOne", darkSteelPowerStorageLevelOne, "Amount of power stored by dark steel items with a level 1 upgrade.").getInt(darkSteelPowerStorageLevelOne);
        darkSteelPowerStorageLevelTwo = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorageLevelTwo", darkSteelPowerStorageLevelTwo, "Amount of power stored by dark steel items with a level 2 upgrade.").getInt(darkSteelPowerStorageLevelTwo);
        darkSteelPowerStorageLevelThree = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorageLevelThree", darkSteelPowerStorageLevelThree, "Amount of power stored by dark steel items with a level 3 upgrade.").getInt(darkSteelPowerStorageLevelThree);
        darkSteelUpgradeVibrantCost = config.get(Config.sectionDarkSteel.name, "darkSteelUpgradeVibrantCost", darkSteelUpgradeVibrantCost, "Number of levels required for the 'Empowered.").getInt(darkSteelUpgradeVibrantCost);
        darkSteelUpgradePowerOneCost = config.get(Config.sectionDarkSteel.name, "darkSteelUpgradePowerOneCost", darkSteelUpgradePowerOneCost, "Number of levels required for the 'Power 1.").getInt(darkSteelUpgradePowerOneCost);
        darkSteelUpgradePowerTwoCost = config.get(Config.sectionDarkSteel.name, "darkSteelUpgradePowerTwoCost", darkSteelUpgradePowerTwoCost, "Number of levels required for the 'Power 2.").getInt(darkSteelUpgradePowerTwoCost);
        darkSteelUpgradePowerThreeCost = config.get(Config.sectionDarkSteel.name, "darkSteelUpgradePowerThreeCost", darkSteelUpgradePowerThreeCost, "Number of levels required for the 'Power 3' upgrade.").getInt(darkSteelUpgradePowerThreeCost);
        darkSteelJumpOneCost = config.get(Config.sectionDarkSteel.name, "darkSteelJumpOneCost", darkSteelJumpOneCost, "Number of levels required for the 'Jump 1' upgrade.").getInt(darkSteelJumpOneCost);
        darkSteelJumpTwoCost = config.get(Config.sectionDarkSteel.name, "darkSteelJumpTwoCost", darkSteelJumpTwoCost, "Number of levels required for the 'Jump 2' upgrade.").getInt(darkSteelJumpTwoCost);
        darkSteelJumpThreeCost = config.get(Config.sectionDarkSteel.name, "darkSteelJumpThreeCost", darkSteelJumpThreeCost, "Number of levels required for the 'Jump 3' upgrade.").getInt(darkSteelJumpThreeCost);
        darkSteelSpeedOneCost = config.get(Config.sectionDarkSteel.name, "darkSteelSpeedOneCost", darkSteelSpeedOneCost, "Number of levels required for the 'Speed 1' upgrade.").getInt(darkSteelSpeedOneCost);
        darkSteelSpeedTwoCost = config.get(Config.sectionDarkSteel.name, "darkSteelSpeedTwoCost", darkSteelSpeedTwoCost, "Number of levels required for the 'Speed 2' upgrade.").getInt(darkSteelSpeedTwoCost);
        darkSteelSpeedThreeCost = config.get(Config.sectionDarkSteel.name, "darkSteelSpeedThreeCost", darkSteelSpeedThreeCost, "Number of levels required for the 'Speed 3' upgrade.").getInt(darkSteelSpeedThreeCost);
        slotZeroPlacesEight = config.get(Config.sectionDarkSteel.name, "shouldSlotZeroWrap", slotZeroPlacesEight, "Should the dark steel placement, when in the first (0th) slot, place the item in the last slot. If false, will place what's in the second slot.").getBoolean();
        darkSteelBootsJumpModifier = config.get(Config.sectionDarkSteel.name, "darkSteelBootsJumpModifier", darkSteelBootsJumpModifier, "Jump height modifier applied when jumping with Dark Steel Boots equipped").getDouble(darkSteelBootsJumpModifier);
        darkSteelPowerStorageBase = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorage", darkSteelPowerStorageBase, "Amount of power stored energy per crystal in the armor items recipe.").getInt(darkSteelPowerStorageBase);
        darkSteelWalkPowerCost = config.get(Config.sectionDarkSteel.name, "darkSteelWalkPowerCost", darkSteelWalkPowerCost, "Amount of power stored energy per block walked when wearing the dark steel boots.").getInt(darkSteelWalkPowerCost);
        darkSteelSprintPowerCost = config.get(Config.sectionDarkSteel.name, "darkSteelSprintPowerCost", darkSteelWalkPowerCost, "Amount of power stored energy per block walked when wearing the dark steel boots.").getInt(darkSteelSprintPowerCost);
        darkSteelDrainPowerFromInventory = config.get(Config.sectionDarkSteel.name, "darkSteelDrainPowerFromInventory", darkSteelDrainPowerFromInventory, "If true, dark steel armor will drain power stored energy in power containers in the players inventory.").getBoolean(darkSteelDrainPowerFromInventory);
        darkSteelBootsJumpPowerCost = config.get(Config.sectionDarkSteel.name, "darkSteelBootsJumpPowerCost", darkSteelBootsJumpPowerCost, "Base amount of power used per jump energy dark steel boots. The second jump in a 'double jump' uses 2x this etc").getInt(darkSteelBootsJumpPowerCost);
        darkSteelFallDistanceCost = config.get(Config.sectionDarkSteel.name, "darkSteelFallDistanceCost", darkSteelFallDistanceCost, "Amount of power used energy per block height of fall distance damage negated.").getInt(darkSteelFallDistanceCost);
        darkSteelSwimCost = config.get(Config.sectionDarkSteel.name, "darkSteelSwimCost", darkSteelSwimCost, "Number of levels required for the 'Swim' upgrade.").getInt(darkSteelSwimCost);
        darkSteelNightVisionCost = config.get(Config.sectionDarkSteel.name, "darkSteelNightVisionCost", darkSteelNightVisionCost, "Number of levels required for the 'Night Vision' upgrade.").getInt(darkSteelNightVisionCost);
        darkSteelTOPCost = config.get(Config.sectionDarkSteel.name, "darkSteelTOPCost", darkSteelTOPCost, "Number of levels required for the 'The One Probe' upgrade.").getInt(darkSteelTOPCost);
        darkSteelGliderCost = config.get(Config.sectionDarkSteel.name, "darkSteelGliderCost", darkSteelGliderCost, "Number of levels required for the 'Glider' upgrade.").getInt(darkSteelGliderCost);
        darkSteelGliderHorizontalSpeed = config.get(Config.sectionDarkSteel.name, "darkSteelGliderHorizontalSpeed", darkSteelGliderHorizontalSpeed, "Horizontal movement speed modifier when gliding.").getDouble(darkSteelGliderHorizontalSpeed);
        darkSteelGliderVerticalSpeed = config.get(Config.sectionDarkSteel.name, "darkSteelGliderVerticalSpeed", darkSteelGliderVerticalSpeed, "Rate of altitude loss when gliding.").getDouble(darkSteelGliderVerticalSpeed);
        darkSteelGliderVerticalSpeedSprinting = config.get(Config.sectionDarkSteel.name, "darkSteelGliderVerticalSpeedSprinting", darkSteelGliderVerticalSpeedSprinting, "Rate of altitude loss when sprinting and gliding.").getDouble(darkSteelGliderVerticalSpeedSprinting);
        darkSteelElytraCost = config.get(Config.sectionDarkSteel.name, "darkSteelElytraCost", darkSteelElytraCost, "Number of levels required for the 'Elytra' upgrade.").getInt(darkSteelElytraCost);
        darkSteelSoundLocatorCost = config.get(Config.sectionDarkSteel.name, "darkSteelSoundLocatorCost", darkSteelSoundLocatorCost, "Number of levels required for the 'Sound Locator' upgrade.").getInt(darkSteelSoundLocatorCost);
        darkSteelSoundLocatorRange = config.get(Config.sectionDarkSteel.name, "darkSteelSoundLocatorRange", darkSteelSoundLocatorRange, "Range of the 'Sound Locator' upgrade.").getInt(darkSteelSoundLocatorRange);
        darkSteelSoundLocatorLifespan = config.get(Config.sectionDarkSteel.name, "darkSteelSoundLocatorLifespan", darkSteelSoundLocatorLifespan, "Number of ticks the 'Sound Locator' icons are displayed for.").getInt(darkSteelSoundLocatorLifespan);
        darkSteelGogglesOfRevealingCost = config.get(Config.sectionDarkSteel.name, "darkSteelGogglesOfRevealingCost", darkSteelGogglesOfRevealingCost, "Number of levels required for the Goggles of Revealing upgrade.").getInt(darkSteelGogglesOfRevealingCost);
        darkSteelTravelCost = config.get(Config.sectionDarkSteel.name, "darkSteelTravelCost", darkSteelTravelCost, "Number of levels required for the 'Travel' upgrade.").getInt(darkSteelTravelCost);
        darkSteelSpoonCost = config.get(Config.sectionDarkSteel.name, "darkSteelSpoonCost", darkSteelSpoonCost, "Number of levels required for the 'Spoon' upgrade.").getInt(darkSteelSpoonCost);
        darkSteelSolarChargeOthers = config.get(Config.sectionDarkSteel.name, "darkSteelSolarChargeOthers", darkSteelSolarChargeOthers, "If enabled allows the solar upgrade to charge non-darksteel armors that the player is wearing.").getBoolean();
        darkSteelSwordSkullChance = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordSkullChance", (double)darkSteelSwordSkullChance, "The base chance that a skull will be dropped when using a powered dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)darkSteelSwordSkullChance);
        darkSteelSwordSkullLootingModifier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordSkullLootingModifier", (double)darkSteelSwordSkullLootingModifier, "The chance per looting level that a skull will be dropped when using a powered dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)darkSteelSwordSkullLootingModifier);
        darkSteelSwordWitherSkullChance = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordWitherSkullChance", (double)darkSteelSwordWitherSkullChance, "The base chance that a wither skull will be dropped when using a powered dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)darkSteelSwordWitherSkullChance);
        darkSteelSwordWitherSkullLootingModifier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordWitherSkullLootingModifie", (double)darkSteelSwordWitherSkullLootingModifier, "The chance per looting level that a wither skull will be dropped when using a powered dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)darkSteelSwordWitherSkullLootingModifier);
        vanillaSwordSkullChance = (float)config.get(Config.sectionDarkSteel.name, "vanillaSwordSkullChance", (double)vanillaSwordSkullChance, "The base chance that a skull will be dropped when using a non dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)vanillaSwordSkullChance);
        vanillaSwordSkullLootingModifier = (float)config.get(Config.sectionDarkSteel.name, "vanillaSwordSkullLootingModifier", (double)vanillaSwordSkullLootingModifier, "The chance per looting level that a skull will be dropped when using a non-dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)vanillaSwordSkullLootingModifier);
        ticCleaverSkullDropChance = (float)config.get(Config.sectionDarkSteel.name, "ticCleaverSkullDropChance", (double)ticCleaverSkullDropChance, "The base chance that an Enderman Skull will be dropped when using TiC Cleaver").getDouble((double)ticCleaverSkullDropChance);
        ticBeheadingSkullModifier = (float)config.get(Config.sectionDarkSteel.name, "ticBeheadingSkullModifier", (double)ticBeheadingSkullModifier, "The chance per level of Beheading that a skull will be dropped when using a TiC weapon").getDouble((double)ticBeheadingSkullModifier);
        fakePlayerSkullChance = (float)config.get(Config.sectionDarkSteel.name, "fakePlayerSkullChance", (double)fakePlayerSkullChance, "The ratio of skull drops when a mob is killed by a 'FakePlayer', such as Killer Joe. When set to 0 no skulls will drop, at 1 the rate of skull drops is not modified").getDouble((double)fakePlayerSkullChance);
        darkSteelSwordPowerUsePerHit = config.get(Config.sectionDarkSteel.name, "darkSteelSwordPowerUsePerHit", darkSteelSwordPowerUsePerHit, "The amount of energy used per hit.").getInt(darkSteelSwordPowerUsePerHit);
        darkSteelSwordEnderPearlDropChance = config.get(Config.sectionDarkSteel.name, "darkSteelSwordEnderPearlDropChance", darkSteelSwordEnderPearlDropChance, "The chance that an ender pearl will be dropped when using a dark steel sword (0 = no chance, 1 = 100% chance)").getDouble(darkSteelSwordEnderPearlDropChance);
        darkSteelSwordEnderPearlDropChancePerLooting = config.get(Config.sectionDarkSteel.name, "darkSteelSwordEnderPearlDropChancePerLooting", darkSteelSwordEnderPearlDropChancePerLooting, "The chance for each looting level that an additional ender pearl will be dropped when using a dark steel sword (0 = no chance, 1 = 100% chance)").getDouble(darkSteelSwordEnderPearlDropChancePerLooting);
        darkSteelBowDamageBonus = (float)config.get(Config.sectionDarkSteel.name, "darkSteelBowDamageBonus", (double)darkSteelBowDamageBonus, "The damage bonus applied to arrows fire from the bow.").getDouble((double)darkSteelBowDamageBonus);
        darkSteelBowForceMultipliers = config.get(Config.sectionDarkSteel.name, "darkSteelBowForceMultipliers", darkSteelBowForceMultipliers, "Multiplier that effects the speed with which arrows leave the bow.").getDoubleList();
        darkSteelBowFovMultipliers = config.get(Config.sectionDarkSteel.name, "darkSteelBowFovMultiplier", darkSteelBowFovMultipliers, "The reduction in FOV when the bow is fullen drawn (the zoom level). A 'vanilla' bow has a value of 0.15").getDoubleList();
        darkSteelBowPowerUsePerDamagePoint = config.get(Config.sectionDarkSteel.name, "darkSteelBowPowerUsePerDamagePoint", darkSteelBowPowerUsePerDamagePoint, "The amount of energy used per hit.").getInt(darkSteelBowPowerUsePerDamagePoint);
        darkSteelBowDrawSpeeds = config.get(Config.sectionDarkSteel.name, "darkSteelBowDrawSpeeds", darkSteelBowDrawSpeeds, "A list of the amount of draw speeds at the different upgrade levels. A vanilla bow draw speed is 20").getIntList();
        darkSteelBowPowerUsePerDraw = config.get(Config.sectionDarkSteel.name, "darkSteelBowPowerUsePerDraw", darkSteelBowPowerUsePerDraw, "The power used to fully draw the bow").getInt(darkSteelBowPowerUsePerDraw);
        darkSteelBowPowerUsePerTickDrawn = config.get(Config.sectionDarkSteel.name, "darkSteelBowPowerUsePerTickDrawn", darkSteelBowPowerUsePerTickDrawn, "The power used per tick to hold the boy fully drawn").getInt(darkSteelBowPowerUsePerTickDrawn);
        darkSteelPickPowerUseObsidian = config.get(Config.sectionDarkSteel.name, "darkSteelPickPowerUseObsidian", darkSteelPickPowerUseObsidian, "The amount of energy used to break an obsidian block.").getInt(darkSteelPickPowerUseObsidian);
        darkSteelPickEffeciencyObsidian = config.get(Config.sectionDarkSteel.name, "darkSteelPickEffeciencyObsidian", darkSteelPickEffeciencyObsidian, "The efficiency when breaking obsidian with a powered Dark Pickaxe.").getInt(darkSteelPickEffeciencyObsidian);
        darkSteelPickApplyObsidianEffeciencyAtHardess = (float)config.get(Config.sectionDarkSteel.name, "darkSteelPickApplyObsidianEffeciencyAtHardess", (double)darkSteelPickApplyObsidianEffeciencyAtHardess, "If set to a value > 0, the obsidian speed and power use will be used for all blocks with hardness >= to this value.").getDouble((double)darkSteelPickApplyObsidianEffeciencyAtHardess);
        darkSteelPickPowerUsePerDamagePoint = config.get(Config.sectionDarkSteel.name, "darkSteelPickPowerUsePerDamagePoint", darkSteelPickPowerUsePerDamagePoint, "Energy use per damage/durability point avoided.").getInt(darkSteelPickPowerUsePerDamagePoint);
        darkSteelPickEffeciencyBoostWhenPowered = (float)config.get(Config.sectionDarkSteel.name, "darkSteelPickEffeciencyBoostWhenPowered", (double)darkSteelPickEffeciencyBoostWhenPowered, "The increase in efficiency when powered.").getDouble((double)darkSteelPickEffeciencyBoostWhenPowered);
        darkSteelPickMinesTiCArdite = config.getBoolean("darkSteelPickMinesTiCArdite", Config.sectionDarkSteel.name, darkSteelPickMinesTiCArdite, "When true the dark steel pick will be able to mine TiC Ardite and Cobalt");
        darkSteelAxePowerUsePerDamagePoint = config.get(Config.sectionDarkSteel.name, "darkSteelAxePowerUsePerDamagePoint", darkSteelAxePowerUsePerDamagePoint, "Energy per damage/durability point avoided.").getInt(darkSteelAxePowerUsePerDamagePoint);
        darkSteelAxePowerUsePerDamagePointMultiHarvest = config.get(Config.sectionDarkSteel.name, "darkSteelPickAxeUsePerDamagePointMultiHarvest", darkSteelAxePowerUsePerDamagePointMultiHarvest, "Energy per damage/durability point avoided when shift-harvesting multiple logs").getInt(darkSteelAxePowerUsePerDamagePointMultiHarvest);
        darkSteelAxeSpeedPenaltyMultiHarvest = (float)config.get(Config.sectionDarkSteel.name, "darkSteelAxeSpeedPenaltyMultiHarvest", (double)darkSteelAxeSpeedPenaltyMultiHarvest, "How much slower shift-harvesting logs is.").getDouble((double)darkSteelAxeSpeedPenaltyMultiHarvest);
        darkSteelAxeEffeciencyBoostWhenPowered = (float)config.get(Config.sectionDarkSteel.name, "darkSteelAxeEffeciencyBoostWhenPowered", (double)darkSteelAxeEffeciencyBoostWhenPowered, "The increase in efficiency when powered.").getDouble((double)darkSteelAxeEffeciencyBoostWhenPowered);
        darkSteelShearsDurabilityFactor = config.get(Config.sectionDarkSteel.name, "darkSteelShearsDurabilityFactor", darkSteelShearsDurabilityFactor, "How much more durable as vanilla shears they are.").getInt(darkSteelShearsDurabilityFactor);
        darkSteelShearsPowerUsePerDamagePoint = config.get(Config.sectionDarkSteel.name, "darkSteelShearsPowerUsePerDamagePoint", darkSteelShearsPowerUsePerDamagePoint, "Energy use per damage/durability point avoided.").getInt(darkSteelShearsPowerUsePerDamagePoint);
        darkSteelShearsEffeciencyBoostWhenPowered = (float)config.get(Config.sectionDarkSteel.name, "darkSteelShearsEffeciencyBoostWhenPowered", (double)darkSteelShearsEffeciencyBoostWhenPowered, "The increase in efficiency when powered.").getDouble((double)darkSteelShearsEffeciencyBoostWhenPowered);
        darkSteelShearsBlockAreaBoostWhenPowered = config.get(Config.sectionDarkSteel.name, "darkSteelShearsBlockAreaBoostWhenPowered", darkSteelShearsBlockAreaBoostWhenPowered, "The increase in effected area (radius) when powered and used on blocks.").getInt(darkSteelShearsBlockAreaBoostWhenPowered);
        darkSteelShearsEntityAreaBoostWhenPowered = (float)config.get(Config.sectionDarkSteel.name, "darkSteelShearsEntityAreaBoostWhenPowered", (double)darkSteelShearsEntityAreaBoostWhenPowered, "The increase in effected area (radius) when powered and used on sheep.").getDouble((double)darkSteelShearsEntityAreaBoostWhenPowered);
        darkSteelAnvilDamageChance = (float)config.get(Config.sectionDarkSteel.name, "darkSteelAnvilDamageChance", (double)darkSteelAnvilDamageChance, "Chance that the dark steel anvil will take damage after repairing something.").getDouble();
        darkSteelLadderSpeedBoost = (float)config.get(Config.sectionDarkSteel.name, "darkSteelLadderSpeedBoost", (double)darkSteelLadderSpeedBoost, "Speed boost, in blocks per tick, that the DS ladder gives over the vanilla ladder.").getDouble();
        hootchPowerPerCycleRF = config.get(Config.sectionPower.name, "hootchPowerPerCycleRF", hootchPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 30, BC Fuel = 60").getInt(hootchPowerPerCycleRF);
        hootchPowerTotalBurnTime = config.get(Config.sectionPower.name, "hootchPowerTotalBurnTime", hootchPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(hootchPowerTotalBurnTime);
        rocketFuelPowerPerCycleRF = config.get(Config.sectionPower.name, "rocketFuelPowerPerCycleRF", rocketFuelPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 3, BC Fuel = 6").getInt(rocketFuelPowerPerCycleRF);
        rocketFuelPowerTotalBurnTime = config.get(Config.sectionPower.name, "rocketFuelPowerTotalBurnTime", rocketFuelPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(rocketFuelPowerTotalBurnTime);
        fireWaterPowerPerCycleRF = config.get(Config.sectionPower.name, "fireWaterPowerPerCycleRF", fireWaterPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 30, BC Fuel = 60").getInt(fireWaterPowerPerCycleRF);
        fireWaterPowerTotalBurnTime = config.get(Config.sectionPower.name, "fireWaterPowerTotalBurnTime", fireWaterPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(fireWaterPowerTotalBurnTime);
        ConfigCategory hoes = config.getCategory(Config.sectionHoes.name);
        hoes.setComment("Each value of this category is an item that could be a hoe. You can add more values.");
        for (String hoe : hoeStrings) {
            config.get(Config.sectionHoes.name, hoe, true, "Is this item a hoe that can be used in the farming station?");
        }
        farmHoes = new Things();
        for (Map.Entry entry : hoes.entrySet()) {
            if (!((Property)entry.getValue()).getBoolean()) continue;
            farmHoes.add((String)entry.getKey());
        }
        magnetPowerUsePerSecondRF = config.get(Config.sectionMagnet.name, "magnetPowerUsePerTickRF", magnetPowerUsePerSecondRF, "The amount of energy used per tick when the magnet is active").getInt(magnetPowerUsePerSecondRF);
        magnetPowerCapacityRF = config.get(Config.sectionMagnet.name, "magnetPowerCapacityRF", magnetPowerCapacityRF, "Amount of energy stored in a fully charged magnet").getInt(magnetPowerCapacityRF);
        magnetRange = config.get(Config.sectionMagnet.name, "magnetRange", magnetRange, "Range of the magnet in blocks.").getInt(magnetRange);
        magnetMaxItems = config.get(Config.sectionMagnet.name, "magnetMaxItems", magnetMaxItems, "Maximum number of items the magnet can effect at a time. (-1 for unlimited)").getInt(magnetMaxItems);
        magnetBlacklist = config.getStringList("magnetBlacklist", Config.sectionMagnet.name, magnetBlacklist, "These items will not be picked up by the magnet.");
        magnetAllowInMainInventory = config.get(Config.sectionMagnet.name, "magnetAllowInMainInventory", magnetAllowInMainInventory, "If true the magnet will also work in the main inventory, not just the hotbar").getBoolean(magnetAllowInMainInventory);
        magnetAllowInBaublesSlot = config.get(Config.sectionMagnet.name, "magnetAllowInBaublesSlot", magnetAllowInBaublesSlot, "If true the magnet can be put into the 'amulet' Baubles slot (requires Baubles to be installed)").getBoolean(magnetAllowInBaublesSlot);
        magnetAllowDeactivatedInBaublesSlot = config.get(Config.sectionMagnet.name, "magnetAllowDeactivatedInBaublesSlot", magnetAllowDeactivatedInBaublesSlot, "If true the magnet can be put into the 'amulet' Baubles slot even if switched off (requires Baubles to be installed and magnetAllowInBaublesSlot to be on)").getBoolean(magnetAllowDeactivatedInBaublesSlot);
        magnetBaublesType = config.get(Config.sectionMagnet.name, "magnetBaublesType", magnetBaublesType, "The BaublesType the magnet should be, 'AMULET', 'RING' or 'BELT' (requires Baubles to be installed and magnetAllowInBaublesSlot to be on)").getString();
        nutrientFoodBoostDelay = config.get(Config.sectionFluid.name, "nutrientFluidFoodBoostDelay", (double)nutrientFoodBoostDelay, "The delay in ticks between when nutrient distillation boosts your food value.").getInt((int)nutrientFoodBoostDelay);
        rocketFuelIsExplosive = config.get(Config.sectionFluid.name, "rocketFuelIsExplosive", rocketFuelIsExplosive, "If enabled, Rocket Fuel will explode when in contact with fire.").getBoolean();
        xpVacuumRange = config.get(Config.sectionAdvanced.name, "xpVacuumRange", xpVacuumRange, "The distance from which XP will be gathered by the XP vacuum.").getDouble(xpVacuumRange);
        final NNList temp = new NNList();
        soulVesselBlackList.apply((NNList.Callback)new NNList.Callback<ResourceLocation>(){

            public void apply(@Nonnull ResourceLocation rl) {
                temp.add((Object)rl.toString());
            }
        });
        String[] list = config.getStringList("soulVesselBlackList", Config.sectionSoulVial.name, (String[])temp.toArray((Object[])new String[0]), "Entities listed here will can not be captured in a Soul Vial");
        soulVesselBlackList.clear();
        for (String string : list) {
            if (string == null) continue;
            soulVesselBlackList.add((Object)new ResourceLocation(string));
        }
        temp.clear();
        soulVesselUnspawnableList.apply((NNList.Callback)new NNList.Callback<ResourceLocation>(){

            public void apply(@Nonnull ResourceLocation rl) {
                temp.add((Object)rl.toString());
            }
        });
        list = config.getStringList("soulVesselUnspawnableList", Config.sectionSoulVial.name, (String[])temp.toArray((Object[])new String[0]), "Entities listed here cannot be spawned and must be cloned from a captured entity instead (Attention: Possibility of item duping!)");
        soulVesselUnspawnableList.clear();
        for (String string : list) {
            if (string == null) continue;
            soulVesselUnspawnableList.add((Object)new ResourceLocation(string));
        }
        soulVesselCapturesBosses = config.getBoolean("soulVesselCapturesBosses", Config.sectionSoulVial.name, soulVesselCapturesBosses, "When set to false, any mob with a 'boss bar' won't be able to be captured in the Soul Vial. Note: The Ender Dragon can not be captured, even with this enabled. This is a limitation of the dragon, not the Soul Vial.");
        soulBinderBrokenSpawnerRF = config.get(Config.sectionSoulBinder.name, "soulBinderBrokenSpawnerRF", soulBinderBrokenSpawnerRF, "The amount of energy required to change the type of a broken spawner.").getInt(soulBinderBrokenSpawnerRF);
        soulBinderReanimationRF = config.get(Config.sectionSoulBinder.name, "soulBinderReanimationRF", soulBinderReanimationRF, "The amount of energy required to to re-animated a mob head.").getInt(soulBinderReanimationRF);
        soulBinderEnderCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderEnderCystalRF", soulBinderEnderCystalRF, "The amount of energy required to create an ender crystal.").getInt(soulBinderEnderCystalRF);
        soulBinderAttractorCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderAttractorCystalRF", soulBinderAttractorCystalRF, "The amount of energy required to create an attractor crystal.").getInt(soulBinderAttractorCystalRF);
        soulBinderTunedPressurePlateRF = config.get(Config.sectionSoulBinder.name, "soulBinderTunedPressurePlateRF", soulBinderTunedPressurePlateRF, "The amount of energy required to tune a pressure plate.").getInt(soulBinderTunedPressurePlateRF);
        soulBinderPrecientCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderPrecientCystalRF", soulBinderPrecientCystalRF, "The amount of energy required to create a precient crystal.").getInt(soulBinderPrecientCystalRF);
        soulBinderAttractorCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderAttractorCystalLevels", soulBinderAttractorCystalLevels, "The number of levels required to create an attractor crystal.").getInt(soulBinderAttractorCystalLevels);
        soulBinderEnderCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderEnderCystalLevels", soulBinderEnderCystalLevels, "The number of levels required to create an ender crystal.").getInt(soulBinderEnderCystalLevels);
        soulBinderPrecientCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderPrecientCystalLevels", soulBinderPrecientCystalLevels, "The number of levels required to create a precient crystal.").getInt(soulBinderPrecientCystalLevels);
        soulBinderReanimationLevels = config.get(Config.sectionSoulBinder.name, "soulBinderReanimationLevels", soulBinderReanimationLevels, "The number of levels required to re-animate a mob head.").getInt(soulBinderReanimationLevels);
        soulBinderBrokenSpawnerLevels = config.get(Config.sectionSoulBinder.name, "soulBinderBrokenSpawnerLevels", soulBinderBrokenSpawnerLevels, "The number of levels required to change the type of a broken spawner.").getInt(soulBinderBrokenSpawnerLevels);
        soulBinderTunedPressurePlateLevels = config.get(Config.sectionSoulBinder.name, "soulBinderTunedPressurePlateLevels", soulBinderTunedPressurePlateLevels, "The number of levels required to tune a pressure plate.").getInt(soulBinderTunedPressurePlateLevels);
        slicenspliceToolDamageChance = (float)config.get(Config.sectionAdvanced.name, "slicenspliceToolDamageChance", (double)slicenspliceToolDamageChance, "The chance that a tool will take damage each tick while the Slice'n'Splice is running (0 = no chance, 1 = 100% chance). Tools will always take damage when the crafting is finished.").getDouble((double)slicenspliceToolDamageChance);
        xpObeliskMaxXpLevel = config.get(Config.sectionMisc.name, "xpObeliskMaxXpLevel", xpObeliskMaxXpLevel, "Maximum level of XP the xp obelisk can contain.").getInt();
        maxMobsAttracted = config.get(Config.sectionMisc.name, "maxMobsAttracted", maxMobsAttracted, "Maximum number of mobs any Attraction Obelisk can attract at any time.").getInt();
        glassConnectToTheirVariants = config.getBoolean("glassConnectToTheirVariants", Config.sectionMisc.name, glassConnectToTheirVariants, "If true, quite clear glass and fused quartz will connect textures with their respective enlightened and darkened variants.");
        clearGlassConnectToFusedQuartz = config.getBoolean("clearGlassConnectToFusedQuartz", Config.sectionMisc.name, clearGlassConnectToFusedQuartz, "If true, quite clear glass will connect textures with fused quartz.");
        glassConnectToTheirColorVariants = config.getBoolean("glassConnectToTheirColorVariants", Config.sectionMisc.name, glassConnectToTheirColorVariants, "If true, quite clear glass and fused quartz of different colors will connect textures.");
        paintedGlowstoneRequireSilkTouch = config.getBoolean("paintedGlowstoneRequireSilkTouch", Config.sectionMisc.name, paintedGlowstoneRequireSilkTouch, "If true, painted glowstone will drop dust unless broken with silk touch");
        enableBaublesIntegration = config.getBoolean("enableBaublesIntegration", Config.sectionMisc.name, enableBaublesIntegration, "If false baubles intergation will be disabled even if Baubles is installed");
        teleportEffectProbability = config.get(Config.sectionAdvanced.name, "teleportEffectProbability", teleportEffectProbability, "The probability that Enderios do what they promise.").getDouble(teleportEffectProbability);
        String rareStr = config.get(Config.sectionEnchantments.name, "enchantmentSoulBoundWeight", enchantmentSoulBoundRarity.toString(), "The rarity of the enchantment. COMMON, UNCOMMON, RARE, VERY_RARE ").getString();
        try {
            enchantmentSoulBoundRarity = Enchantment.Rarity.valueOf((String)((String)NullHelper.notnull((Object)rareStr, (String)"invalid config value")));
        }
        catch (Exception e) {
            Log.warn("Could not set value config entry enchantmentWitherArrowRarity Specified value " + rareStr);
            e.printStackTrace();
        }
        CapacitorKey.processConfig(config);
        BaseConfig.load();
        BaseConfig.F.setConfig(config);
    }

    public static void init(FMLPostInitializationEvent event) {
        if (darkSteelPowerDamgeAbsorptionRatios == null || darkSteelPowerDamgeAbsorptionRatios.length != 4) {
            throw new IllegalArgumentException("Ender IO config value darkSteelPowerDamgeAbsorptionRatios must have exactly 4 values");
        }
        if (darkSteelBowForceMultipliers == null || darkSteelBowForceMultipliers.length != 5) {
            throw new IllegalArgumentException("Ender IO config value darkSteelBowForceMultipliers must have exactly 5 values");
        }
        if (darkSteelBowDrawSpeeds == null || darkSteelBowDrawSpeeds.length != 5) {
            throw new IllegalArgumentException("Ender IO config value darkSteelBowDrawSpeeds must have exactly 5 values");
        }
        if (darkSteelBowFovMultipliers == null || darkSteelBowFovMultipliers.length != 5) {
            throw new IllegalArgumentException("Ender IO config value darkSteelBowFovMultipliers must have exactly 5 values");
        }
    }

    private Config() {
    }

    static {
        sectionPower = new Section("Power Settings", "power");
        sectionRecipe = new Section("Recipe Settings", "recipe");
        sectionItems = new Section("Item Enabling", "item");
        sectionEfficiency = new Section("Efficiency Settings", "efficiency");
        sectionAnchor = new Section("Anchor Settings", "anchor");
        sectionStaff = new Section("Staff Settings", "staff");
        sectionRod = new Section("Rod of Return Settings", "rod");
        sectionDarkSteel = new Section("Dark Steel", "darksteel");
        sectionAdvanced = new Section("Advanced Settings", "advanced");
        sectionMagnet = new Section("Magnet Settings", "magnet");
        sectionFluid = new Section("Fluid Settings", "fluid");
        sectionSoulBinder = new Section("Soul Binder Settings", "soulBinder");
        sectionSoulVial = new Section("", "soulvial");
        sectionEnchantments = new Section("Enchantments", "enchantments");
        sectionMisc = new Section("Misc", "misc");
        sectionCapacitor = new Section("Capacitor Values", "capacitor");
        sectionHoes = new Section("Farm Settings.Hoes", "hoes");
        conduitScale = 0.6;
        travelAnchorMaximumDistance = 96;
        travelAnchorCooldown = 0;
        travelAnchorSneak = true;
        travelAnchorSkipWarning = true;
        travelStaffMaximumDistance = 256;
        travelStaffPowerPerBlockRF = 250.0f;
        travelStaffMaxBlinkDistance = 16;
        travelStaffBlinkPauseTicks = 10;
        travelStaffBlinkEnabled = true;
        travelStaffBlinkThroughSolidBlocksEnabled = true;
        travelStaffBlinkThroughClearBlocksEnabled = true;
        travelStaffBlinkThroughUnbreakableBlocksEnabled = false;
        travelStaffBlinkBlackList = new String[]{"minecraft:bedrock", "Thaumcraft:blockWarded"};
        travelStaffOffhandBlinkEnabled = true;
        travelStaffOffhandTravelEnabled = true;
        travelStaffOffhandShowsTravelTargets = true;
        travelAnchorZoomScale = 0.2f;
        darkSteelPowerDamgeAbsorptionRatios = new double[]{0.5, 0.6, 0.7, 0.85};
        darkSteelPowerStorageBase = 100000;
        darkSteelPowerStorageLevelOne = 150000;
        darkSteelPowerStorageLevelTwo = 250000;
        darkSteelPowerStorageLevelThree = 1000000;
        darkSteelSpeedOneCost = 4;
        darkSteelSpeedTwoCost = 6;
        darkSteelSpeedThreeCost = 8;
        darkSteelBootsJumpModifier = 1.5;
        darkSteelJumpOneCost = 4;
        darkSteelJumpTwoCost = 6;
        darkSteelJumpThreeCost = 8;
        slotZeroPlacesEight = true;
        darkSteelWalkPowerCost = darkSteelPowerStorageLevelTwo / 3000;
        darkSteelSprintPowerCost = darkSteelWalkPowerCost * 4;
        darkSteelDrainPowerFromInventory = false;
        darkSteelBootsJumpPowerCost = 150;
        darkSteelFallDistanceCost = 75;
        darkSteelSwordWitherSkullChance = 0.05f;
        darkSteelSwordWitherSkullLootingModifier = 0.05f;
        darkSteelSwordSkullChance = 0.1f;
        darkSteelSwordSkullLootingModifier = 0.075f;
        vanillaSwordSkullLootingModifier = 0.05f;
        vanillaSwordSkullChance = 0.05f;
        ticCleaverSkullDropChance = 0.1f;
        ticBeheadingSkullModifier = 0.075f;
        fakePlayerSkullChance = 0.5f;
        darkSteelSwordPowerUsePerHit = 750;
        darkSteelSwordEnderPearlDropChance = 1.05;
        darkSteelSwordEnderPearlDropChancePerLooting = 0.5;
        darkSteelBowDamageBonus = 0.0f;
        darkSteelBowForceMultipliers = new double[]{1.1f, 1.2f, 1.3f, 1.4f, 1.5};
        darkSteelBowDrawSpeeds = new int[]{30, 20, 18, 16, 14};
        darkSteelBowFovMultipliers = new double[]{0.25, 0.3, 0.35, 0.4, 0.45};
        darkSteelBowPowerUsePerDamagePoint = 1000;
        darkSteelBowPowerUsePerDraw = 750;
        darkSteelBowPowerUsePerTickDrawn = 5;
        darkSteelPickEffeciencyObsidian = 50;
        darkSteelPickPowerUseObsidian = 10000;
        darkSteelPickApplyObsidianEffeciencyAtHardess = 40.0f;
        darkSteelPickPowerUsePerDamagePoint = 750;
        darkSteelPickEffeciencyBoostWhenPowered = 2.0f;
        darkSteelPickMinesTiCArdite = true;
        darkSteelAxePowerUsePerDamagePoint = 750;
        darkSteelAxePowerUsePerDamagePointMultiHarvest = 1500;
        darkSteelAxeEffeciencyBoostWhenPowered = 2.0f;
        darkSteelAxeSpeedPenaltyMultiHarvest = 4.0f;
        darkSteelShearsDurabilityFactor = 5;
        darkSteelShearsPowerUsePerDamagePoint = 250;
        darkSteelShearsEffeciencyBoostWhenPowered = 2.0f;
        darkSteelShearsBlockAreaBoostWhenPowered = 4;
        darkSteelShearsEntityAreaBoostWhenPowered = 5.0f;
        darkSteelUpgradeVibrantCost = 4;
        darkSteelUpgradePowerOneCost = 6;
        darkSteelUpgradePowerTwoCost = 8;
        darkSteelUpgradePowerThreeCost = 12;
        darkSteelGliderCost = 4;
        darkSteelGliderHorizontalSpeed = 0.03;
        darkSteelGliderVerticalSpeed = -0.05;
        darkSteelGliderVerticalSpeedSprinting = -0.15;
        darkSteelElytraCost = 10;
        darkSteelGogglesOfRevealingCost = 4;
        darkSteelSwimCost = 4;
        darkSteelNightVisionCost = 4;
        darkSteelTOPCost = 4;
        darkSteelSoundLocatorCost = 4;
        darkSteelSoundLocatorRange = 40;
        darkSteelSoundLocatorLifespan = 40;
        darkSteelTravelCost = 16;
        darkSteelSpoonCost = 4;
        darkSteelSolarChargeOthers = true;
        darkSteelAnvilDamageChance = 0.024f;
        darkSteelLadderSpeedBoost = 0.06f;
        hootchPowerPerCycleRF = 60;
        hootchPowerTotalBurnTime = 6000;
        rocketFuelPowerPerCycleRF = 160;
        rocketFuelPowerTotalBurnTime = 7000;
        fireWaterPowerPerCycleRF = 80;
        fireWaterPowerTotalBurnTime = 15000;
        hoeStrings = new String[]{"tconstruct:mattock", "thermalfoundation:tool.hoe_invar", "thermalfoundation:tool.hoe_copper", "thermalfoundation:tool.hoe_bronze", "thermalfoundation:tool.hoe_silver", "thermalfoundation:tool.hoe_electrum", "thermalfoundation:tool.hoe_tin", "thermalfoundation:tool.hoe_lead", "thermalfoundation:tool.hoe_nickel", "thermalfoundation:tool.hoe_platinum", "thermalfoundation:tool.hoe_aluminum", "thermalfoundation:tool.hoe_steel", "thermalfoundation:tool.hoe_constantan", "basemetals:adamantine_hoe", "basemetals:aquarium_hoe", "basemetals:brass_hoe", "basemetals:bronze_hoe", "basemetals:coldiron_hoe", "basemetals:copper_hoe", "basemetals:cupronickel_hoe", "basemetals:electrum_hoe", "basemetals:invar_hoe", "basemetals:lead_hoe", "basemetals:mithril_hoe", "basemetals:nickel_hoe", "basemetals:platinum_hoe", "basemetals:silver_hoe", "basemetals:starsteel_hoe", "basemetals:steel_hoe", "basemetals:tin_hoe", "actuallyadditions:item_hoe_quartz", "actuallyadditions:item_hoe_emerald", "actuallyadditions:item_hoe_obsidian", "actuallyadditions:item_hoe_crystal_red", "actuallyadditions:item_hoe_crystal_blue", "actuallyadditions:item_hoe_crystal_light_blue", "actuallyadditions:item_hoe_crystal_black", "actuallyadditions:item_hoe_crystal_green", "actuallyadditions:item_hoe_crystal_white", "ic2:bronze_hoe", "appliedenergistics2:nether_quartz_hoe", "appliedenergistics2:certus_quartz_hoe", "railcraft:tool_hoe_steel", "mysticalagriculture:inferium_hoe", "mysticalagriculture:prudentium_hoe", "mysticalagriculture:intermedium_hoe", "mysticalagriculture:superium_hoe", "mysticalagriculture:supremium_hoe"};
        farmHoes = new Things();
        magnetPowerUsePerSecondRF = 1;
        magnetPowerCapacityRF = 100000;
        magnetRange = 5;
        magnetBlacklist = new String[]{"appliedenergistics2:item.ItemCrystalSeed", "Botania:livingrock", "Botania:manaTablet"};
        magnetMaxItems = 20;
        magnetAllowInMainInventory = false;
        magnetAllowInBaublesSlot = true;
        magnetAllowDeactivatedInBaublesSlot = false;
        magnetBaublesType = "AMULET";
        nutrientFoodBoostDelay = 400L;
        rocketFuelIsExplosive = true;
        xpVacuumRange = 10.0;
        soulVesselBlackList = new NNList();
        soulVesselUnspawnableList = new NNList();
        soulVesselCapturesBosses = false;
        soulBinderBrokenSpawnerRF = 2500000;
        soulBinderBrokenSpawnerLevels = 8;
        soulBinderReanimationRF = 100000;
        soulBinderReanimationLevels = 4;
        soulBinderEnderCystalRF = 150000;
        soulBinderEnderCystalLevels = 6;
        soulBinderPrecientCystalRF = 200000;
        soulBinderPrecientCystalLevels = 8;
        soulBinderAttractorCystalRF = 100000;
        soulBinderAttractorCystalLevels = 4;
        soulBinderTunedPressurePlateLevels = 2;
        soulBinderTunedPressurePlateRF = 250000;
        slicenspliceToolDamageChance = 0.01f;
        xpObeliskMaxXpLevel = Integer.MAX_VALUE;
        clearGlassConnectToFusedQuartz = false;
        glassConnectToTheirVariants = true;
        glassConnectToTheirColorVariants = true;
        enchantmentSoulBoundRarity = Enchantment.Rarity.VERY_RARE;
        rodOfReturnCanTargetAnywhere = false;
        rodOfReturnTicksToActivate = 50;
        rodOfReturnPowerStorage = 2000000;
        rodOfReturnMinTicksToRecharge = 100;
        rodOfReturnRfPerTick = 35000;
        rodOfReturnFluidUsePerTeleport = 200;
        rodOfReturnFluidStorage = 200;
        rodOfReturnFluidType = "ender_distillation";
        paintedGlowstoneRequireSilkTouch = false;
        enableBaublesIntegration = true;
        maxMobsAttracted = 20;
        teleportEffectProbability = 0.03f;
        TRAVEL_BLACKLIST = new Things(travelStaffBlinkBlackList);
    }

    public static class Section {
        @Nonnull
        public final String name;

        public Section(String name, @Nonnull String lang) {
            this.name = lang;
        }
    }
}

