/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.redstone.signals;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.redstone.filters.IOutputSignalFilter;
import crazypants.enderio.base.conduit.redstone.signals.BundledCombinedSignal;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.conduit.redstone.signals.ISignalSource;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BundledSignal {
    @Nonnull
    private final Map<DyeColor, NNList<Signal>> bundle = new EnumMap<DyeColor, NNList<Signal>>(DyeColor.class);

    public BundledSignal() {
        NNList.of(DyeColor.class).apply((NNList.Callback)new NNList.Callback<DyeColor>(){

            public void apply(@Nonnull DyeColor color) {
                BundledSignal.this.bundle.put(color, new NNList());
            }
        });
    }

    @Nonnull
    public NNList<Signal> get(@Nonnull DyeColor color) {
        return this.bundle.get(color).copy();
    }

    public void set(@Nonnull DyeColor color, @Nonnull NNList<Signal> signals) {
        this.bundle.put(color, (NNList<Signal>)signals.copy());
    }

    public void clear(@Nonnull DyeColor color) {
        this.bundle.get(color).clear();
    }

    public void add(@Nonnull Signal signal) {
        this.bundle.get(signal.getColor()).add((Object)signal);
    }

    @Nonnull
    public CombinedSignal get(@Nonnull DyeColor color, @Nonnull IOutputSignalFilter filter, @Nullable ISignalSource ignore) {
        return filter.apply(color, this, ignore);
    }

    @Nonnull
    public CombinedSignal get(@Nonnull DyeColor color, @Nullable ISignalSource ignore) {
        CombinedSignal result = CombinedSignal.NONE;
        for (Signal signal : this.get(color)) {
            if (ignore != null && (ignore.getSource().equals((Object)signal.getSource()) || ignore.getDir().equals((Object)signal.getDir())) || result.getStrength() >= signal.getStrength()) continue;
            result = signal;
        }
        return result;
    }

    @Nonnull
    public BundledCombinedSignal get(final @Nullable ISignalSource ignore) {
        final BundledCombinedSignal result = new BundledCombinedSignal();
        NNList.of(DyeColor.class).apply((NNList.Callback)new NNList.Callback<DyeColor>(){

            public void apply(@Nonnull DyeColor color) {
                for (Signal signal : BundledSignal.this.get(color)) {
                    if (ignore != null && (ignore.getSource().equals((Object)signal.getSource()) || ignore.getDir().equals((Object)signal.getDir())) || result.get(color).getStrength() >= signal.getStrength()) continue;
                    result.set(signal);
                }
            }
        });
        return result;
    }
}

