/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.redstone.signals;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class BundledCombinedSignal {
    @Nonnull
    private final Map<DyeColor, CombinedSignal> bundle = new EnumMap<DyeColor, CombinedSignal>(DyeColor.class);

    public BundledCombinedSignal() {
        NNList.of(DyeColor.class).apply((NNList.Callback)new NNList.Callback<DyeColor>(){

            public void apply(@Nonnull DyeColor color) {
                BundledCombinedSignal.this.bundle.put(color, CombinedSignal.NONE);
            }
        });
    }

    @Nonnull
    public CombinedSignal get(@Nonnull DyeColor color) {
        return (CombinedSignal)NullHelper.first((Object[])new CombinedSignal[]{this.bundle.get(color), CombinedSignal.NONE});
    }

    public void set(@Nonnull DyeColor color, @Nonnull CombinedSignal signal) {
        this.bundle.put(color, signal);
    }

    public void clear(@Nonnull DyeColor color) {
        this.bundle.put(color, CombinedSignal.NONE);
    }

    public void set(@Nonnull Signal signal) {
        this.bundle.put(signal.getColor(), signal);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (DyeColor color : DyeColor.values()) {
            result = 31 * result + this.bundle.get(color).hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundledCombinedSignal other = (BundledCombinedSignal)obj;
        for (DyeColor color : DyeColor.values()) {
            if (this.bundle.get(color).equals(other.bundle.get(color))) continue;
            return false;
        }
        return true;
    }
}

