/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.redstone;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ConnectivityTool {
    @Nonnull
    private static final Things CONNECTABLES = new Things().add(Blocks.field_150451_bX).add(Blocks.field_150379_bu).add(Blocks.field_150374_bv).add(Blocks.field_150429_aA).add(Blocks.field_150442_at).add(Blocks.field_150430_aB).add(Blocks.field_150471_bO).add((Block)Blocks.field_150455_bV).add((Block)Blocks.field_150441_bU).add((Block)Blocks.field_150416_aS).add((Block)Blocks.field_150413_aR).add((Block)Blocks.field_150453_bW).add((Block)Blocks.field_180402_cm).add(Blocks.field_150367_z).add(Blocks.field_150409_cd).add(Blocks.field_180400_cw).add(Blocks.field_150415_aT).add((Block)Blocks.field_180410_as).add((Block)Blocks.field_180412_aq).add((Block)Blocks.field_180409_at).add((Block)Blocks.field_150454_av).add((Block)Blocks.field_180411_ar).add((Block)Blocks.field_180413_ao).add((Block)Blocks.field_180414_ap).add(Blocks.field_150447_bR).add((Block)Blocks.field_150479_bC).add(Blocks.field_150408_cc).add(Blocks.field_150319_E).add(Blocks.field_150318_D).add((Block)Blocks.field_150488_af);

    public static boolean shouldAutoConnectRedstone(@Nonnull IBlockState state) {
        return CONNECTABLES.contains(state.func_177230_c());
    }

    public static boolean shouldAutoConnectRedstone(@Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing from) {
        if (state.func_177230_c().canConnectRedstone(state, (IBlockAccess)world, pos, from) || ConnectivityTool.shouldAutoConnectRedstone(state)) {
            return true;
        }
        if (state.func_177230_c() instanceof IRedstoneConnectable) {
            return ((IRedstoneConnectable)state.func_177230_c()).shouldRedstoneConduitConnect(world, pos, from);
        }
        IRedstoneConnectable redstoneConnectable = (IRedstoneConnectable)BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos, IRedstoneConnectable.class);
        if (redstoneConnectable != null) {
            redstoneConnectable.shouldRedstoneConduitConnect(world, pos, from);
        }
        return false;
    }

    public static void registerRedstoneAware(@Nonnull Block block) {
        CONNECTABLES.add(block);
    }

    public static void registerRedstoneAware(@Nonnull IBlockState state) {
        ConnectivityTool.registerRedstoneAware(state.func_177230_c());
    }

    public static void registerRedstoneAware(@Nonnull String value) {
        CONNECTABLES.add(value);
    }
}

