/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.geom;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.geom.GeometryKey;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class ConduitGeometryUtil {
    @Nonnull
    public static final ConduitGeometryUtil instance = new ConduitGeometryUtil();
    public static float STUB_WIDTH = 0.2f;
    public static float STUB_HEIGHT = 0.2f;
    public static float WIDTH;
    public static float HEIGHT;
    public static float HWIDTH;
    public static float HHEIGHT;
    public static Vector3d CORE_MIN;
    public static Vector3d CORE_MAX;
    public static BoundingBox CORE_BOUNDS;
    public static final float CONNECTOR_DEPTH = 0.05f;
    @Nonnull
    private static final Map<EnumFacing, BoundingBox[]> EXTERNAL_CONNECTOR_BOUNDS;
    @Nonnull
    private final Map<GeometryKey, BoundingBox> boundsCache = new HashMap<GeometryKey, BoundingBox>();

    @SubscribeEvent
    public static void preInit(EnderIOLifecycleEvent.Config.Post event) {
        Vector3d core_max;
        Vector3d core_min;
        float size;
        WIDTH = size = (float)((double)0.075f + (double)0.175f * Config.conduitScale);
        HEIGHT = size;
        HWIDTH = WIDTH / 2.0f;
        HHEIGHT = HEIGHT / 2.0f;
        CORE_MIN = core_min = new Vector3d((double)(0.5f - HWIDTH), 0.5 - (double)HHEIGHT, 0.5 - (double)HWIDTH);
        CORE_MAX = core_max = new Vector3d(ConduitGeometryUtil.CORE_MIN.x + (double)WIDTH, ConduitGeometryUtil.CORE_MIN.y + (double)HEIGHT, ConduitGeometryUtil.CORE_MIN.z + (double)WIDTH);
        CORE_BOUNDS = new BoundingBox(core_min, core_max);
        float connectorWidth = (float)(0.25 + Config.conduitScale * 0.5);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            EXTERNAL_CONNECTOR_BOUNDS.put(dir, ConduitGeometryUtil.createExternalConnector(dir, 0.05f, connectorWidth));
        }
    }

    @Nonnull
    private static BoundingBox[] createExternalConnector(@Nonnull EnumFacing dir, float connectorDepth, float connectorWidth) {
        BoundingBox[] res = new BoundingBox[2];
        float cMin = 0.5f - connectorWidth / 2.0f;
        float cMax = 0.5f + connectorWidth / 2.0f;
        float dMin = 1.0f - connectorDepth / 2.0f;
        float dMax = 1.0f;
        res[0] = ConduitGeometryUtil.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        cMin = 0.5f - connectorWidth / 3.0f;
        cMax = 0.5f + connectorWidth / 3.0f;
        dMin = 1.0f - connectorDepth;
        dMax = 1.0f - connectorDepth / 2.0f;
        res[1] = ConduitGeometryUtil.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        return res;
    }

    @Nonnull
    private static BoundingBox createConnectorComponent(@Nonnull EnumFacing dir, float cornerMin, float cornerMax, float depthMin, float depthMax) {
        float minX = (float)(1 - Math.abs(dir.func_82601_c())) * cornerMin + (float)dir.func_82601_c() * depthMin;
        float minY = (float)(1 - Math.abs(dir.func_96559_d())) * cornerMin + (float)dir.func_96559_d() * depthMin;
        float minZ = (float)(1 - Math.abs(dir.func_82599_e())) * cornerMin + (float)dir.func_82599_e() * depthMin;
        float maxX = (float)(1 - Math.abs(dir.func_82601_c())) * cornerMax + (float)dir.func_82601_c() * depthMax;
        float maxY = (float)(1 - Math.abs(dir.func_96559_d())) * cornerMax + (float)dir.func_96559_d() * depthMax;
        float maxZ = (float)(1 - Math.abs(dir.func_82599_e())) * cornerMax + (float)dir.func_82599_e() * depthMax;
        minX = ConduitGeometryUtil.fix(minX);
        minY = ConduitGeometryUtil.fix(minY);
        minZ = ConduitGeometryUtil.fix(minZ);
        maxX = ConduitGeometryUtil.fix(maxX);
        maxY = ConduitGeometryUtil.fix(maxY);
        maxZ = ConduitGeometryUtil.fix(maxZ);
        BoundingBox bb = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        bb = bb.fixMinMax();
        return bb;
    }

    private static float fix(float val) {
        return val < 0.0f ? 1.0f + val : val;
    }

    private ConduitGeometryUtil() {
    }

    @Nonnull
    public BoundingBox getExternalConnectorBoundingBox(@Nonnull EnumFacing dir) {
        return this.getExternalConnectorBoundingBoxes(dir)[0];
    }

    @Nonnull
    public BoundingBox[] getExternalConnectorBoundingBoxes(@Nonnull EnumFacing dir) {
        return EXTERNAL_CONNECTOR_BOUNDS.get(dir);
    }

    @Nonnull
    public BoundingBox getBoundingBox(Class<? extends IConduit> type, EnumFacing dir, boolean isStub, Offset offset) {
        GeometryKey key = new GeometryKey(dir, isStub, offset, type);
        BoundingBox result = this.boundsCache.get(key);
        if (result == null) {
            result = this.createConduitBounds(type, key);
            this.boundsCache.put(key, result);
        }
        return result;
    }

    @Nonnull
    public Vector3d getTranslation(EnumFacing dir, @Nonnull Offset offset) {
        Vector3d result = new Vector3d((double)offset.xOffset, (double)offset.yOffset, (double)offset.zOffset);
        result.scale((double)WIDTH);
        return result;
    }

    @Nonnull
    public BoundingBox createBoundsForConnectionController(@Nonnull EnumFacing dir, @Nonnull Offset offset) {
        Vector3d nonUniformScale = ForgeDirectionOffsets.forDirCopy((EnumFacing)dir);
        nonUniformScale.scale(0.5);
        nonUniformScale.x = 0.8 * (1.0 - Math.abs(nonUniformScale.x));
        nonUniformScale.y = 0.8 * (1.0 - Math.abs(nonUniformScale.y));
        nonUniformScale.z = 0.8 * (1.0 - Math.abs(nonUniformScale.z));
        BoundingBox bb = CORE_BOUNDS;
        bb = bb.scale(nonUniformScale.x, nonUniformScale.y, nonUniformScale.z);
        double offsetFromEnd = Math.min(bb.sizeX(), bb.sizeY());
        offsetFromEnd = Math.min(offsetFromEnd, bb.sizeZ());
        offsetFromEnd = Math.max(offsetFromEnd, 0.075);
        double transMag = 0.5 - offsetFromEnd * 1.2;
        Vector3d trans = ForgeDirectionOffsets.forDirCopy((EnumFacing)dir);
        trans.scale(transMag);
        bb = bb.translate(trans);
        bb = bb.translate(this.getTranslation(dir, offset));
        return bb;
    }

    @Nonnull
    private BoundingBox createConduitBounds(@Nonnull Class<? extends IConduit> type, @Nonnull GeometryKey key) {
        return this.createConduitBounds(type, key.dir, key.isStub, key.offset);
    }

    @Nonnull
    private BoundingBox createConduitBounds(Class<? extends IConduit> type, EnumFacing dir, boolean isStub, @Nonnull Offset offset) {
        BoundingBox bb = CORE_BOUNDS;
        Vector3d min = bb.getMin();
        Vector3d max = bb.getMax();
        if (dir != null) {
            switch (dir) {
                case WEST: {
                    min.x = isStub ? Math.max(0.0, bb.field_72340_a - (double)STUB_WIDTH) : 0.0;
                    max.x = bb.field_72340_a;
                    break;
                }
                case EAST: {
                    min.x = bb.field_72336_d;
                    max.x = isStub ? Math.min(1.0, bb.field_72336_d + (double)STUB_WIDTH) : 1.0;
                    break;
                }
                case DOWN: {
                    min.y = isStub ? Math.max(0.0, bb.field_72338_b - (double)STUB_HEIGHT) : 0.0;
                    max.y = bb.field_72338_b;
                    break;
                }
                case UP: {
                    max.y = isStub ? Math.min(1.0, bb.field_72337_e + (double)STUB_HEIGHT) : 1.0;
                    min.y = bb.field_72337_e;
                    break;
                }
                case NORTH: {
                    min.z = isStub ? Math.max(0.0, bb.field_72339_c - (double)STUB_WIDTH) : 0.0;
                    max.z = bb.field_72339_c;
                    break;
                }
                case SOUTH: {
                    max.z = isStub ? Math.min(1.0, bb.field_72334_f + (double)STUB_WIDTH) : 1.0;
                    min.z = bb.field_72334_f;
                    break;
                }
            }
        }
        Vector3d trans = this.getTranslation(dir, offset);
        min.add(trans);
        max.add(trans);
        bb = new BoundingBox(VecmathUtil.clamp((Vector3d)min, (double)0.0, (double)1.0), VecmathUtil.clamp((Vector3d)max, (double)0.0, (double)1.0));
        return bb;
    }

    static {
        EXTERNAL_CONNECTOR_BOUNDS = new HashMap<EnumFacing, BoundingBox[]>();
    }
}

