/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.capacitor.ICapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class NBTCapacitorData
implements ICapacitorData {
    @Nonnull
    private final String unlocalizedName;
    private final float defaultlevel;
    @Nonnull
    private final NBTTagCompound tag;

    public NBTCapacitorData(@Nonnull String unlocalizedName, float defaultlevel, @Nonnull NBTTagCompound tag) {
        this.unlocalizedName = unlocalizedName;
        this.defaultlevel = defaultlevel;
        this.tag = tag;
    }

    @Override
    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public float getUnscaledValue(@Nonnull ICapacitorKey key) {
        NBTTagCompound subtag;
        if (this.tag.func_150297_b(key.getName(), 99)) {
            return this.tag.func_74760_g(key.getName());
        }
        if (this.tag.func_150297_b(key.getOwner().getUnlocalisedName(), 10) && (subtag = this.tag.func_74775_l(key.getOwner().getUnlocalisedName())).func_150297_b(key.getValueType().getName(), 99)) {
            return subtag.func_74760_g(key.getValueType().getName());
        }
        if (this.tag.func_150297_b(key.getValueType().getName(), 99)) {
            return this.tag.func_74760_g(key.getValueType().getName());
        }
        return this.defaultlevel;
    }

    @Override
    @Nonnull
    public String getLocalizedName() {
        return EnderIO.lang.localizeExact(this.unlocalizedName + ".name");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.defaultlevel);
        result = 31 * result + this.tag.hashCode();
        result = 31 * result + this.unlocalizedName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NBTCapacitorData other = (NBTCapacitorData)obj;
        if (Float.floatToIntBits(this.defaultlevel) != Float.floatToIntBits(other.defaultlevel)) {
            return false;
        }
        if (!this.tag.equals((Object)other.tag)) {
            return false;
        }
        return this.unlocalizedName.equals(other.unlocalizedName);
    }
}

