/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.base.capacitor.CapacitorKeyType;
import crazypants.enderio.base.capacitor.ICapacitorData;
import crazypants.enderio.base.capacitor.Scaler;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.init.IModObject;
import javax.annotation.Nonnull;

public interface ICapacitorKey {
    public int get(@Nonnull ICapacitorData var1);

    public float getFloat(@Nonnull ICapacitorData var1);

    @Nonnull
    public IModObject getOwner();

    @Nonnull
    public CapacitorKeyType getValueType();

    @Nonnull
    public String getName();

    public static interface Computable
    extends ICapacitorKey {
        @Nonnull
        public Scaler getScaler();

        public void setScaler(@Nonnull Scaler var1);

        @Nonnull
        public String getConfigKey();

        @Nonnull
        public Config.Section getConfigSection();

        @Nonnull
        public String getConfigComment();

        public int getDefaultBaseValue();

        public int getBaseValue();

        public void setBaseValue(int var1);

        @Override
        default public float getFloat(@Nonnull ICapacitorData capacitor) {
            return (float)this.getBaseValue() * this.getScaler().scaleValue(capacitor.getUnscaledValue(this));
        }

        @Override
        default public int get(@Nonnull ICapacitorData capacitor) {
            return (int)((float)this.getBaseValue() * this.getScaler().scaleValue(capacitor.getUnscaledValue(this)));
        }
    }
}

