/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.base.capacitor.CapacitorKeyType;
import crazypants.enderio.base.capacitor.ICapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.Scaler;
import crazypants.enderio.base.init.IModObject;
import javax.annotation.Nonnull;

public class DefaultCapacitorKey
implements ICapacitorKey {
    @Nonnull
    private final IModObject owner;
    @Nonnull
    private final CapacitorKeyType valueType;
    @Nonnull
    private final Scaler scaler;
    private final int baseValue;

    public DefaultCapacitorKey(@Nonnull IModObject owner, @Nonnull CapacitorKeyType valueType, @Nonnull Scaler scaler, int baseValue) {
        this.owner = owner;
        this.valueType = valueType;
        this.scaler = scaler;
        this.baseValue = baseValue;
    }

    @Override
    public int get(@Nonnull ICapacitorData capacitor) {
        return (int)((float)this.baseValue * this.scaler.scaleValue(capacitor.getUnscaledValue(this)));
    }

    @Override
    public float getFloat(@Nonnull ICapacitorData capacitor) {
        return (float)this.baseValue * this.scaler.scaleValue(capacitor.getUnscaledValue(this));
    }

    @Override
    @Nonnull
    public IModObject getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public CapacitorKeyType getValueType() {
        return this.valueType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.owner + ":" + (Object)((Object)this.valueType);
    }
}

