/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import com.enderio.core.common.Lang;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.Scaler;
import crazypants.enderio.base.config.Config;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public class CapacitorKeyHelper {
    private CapacitorKeyHelper() {
    }

    @Nonnull
    public static String localizeComment(@Nonnull Lang lang, @Nonnull Config.Section configSection, @Nonnull String configKey) {
        String langKey = "config.capacitor." + configKey;
        return lang.localize(langKey);
    }

    public static void processConfig(Configuration config, ICapacitorKey.Computable ... keys) {
        for (ICapacitorKey.Computable key : keys) {
            key.setBaseValue(config.getInt(key.getConfigKey(), key.getConfigSection().name, key.getDefaultBaseValue(), Integer.MIN_VALUE, Integer.MAX_VALUE, key.getConfigComment()));
            String string = Scaler.Factory.toString(key.getScaler());
            if (string == null) continue;
            String string2 = config.getString(key.getConfigKey() + ".scaler", key.getConfigSection().name, string, "Scaler for " + key.getConfigKey());
            Scaler tmp = Scaler.Factory.fromString(string2);
            if (tmp != null) {
                key.setScaler(tmp);
                continue;
            }
            config.get(key.getConfigSection().name, key.getConfigKey() + ".scaler", string, "Scaler for " + key.getConfigKey()).set(string);
        }
    }

    @Nonnull
    public static String createConfigKey(ICapacitorKey key, String configKey) {
        return configKey == null ? key.getName() : configKey;
    }
}

