/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.capacitor.CapacitorKeyHelper;
import crazypants.enderio.base.capacitor.CapacitorKeyType;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.Scaler;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.init.ModObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;

public enum CapacitorKey implements ICapacitorKey.Computable
{
    NO_POWER_INTAKE(ModObject.block_machine_base, CapacitorKeyType.ENERGY_INTAKE, Scaler.Factory.FIXED_1, 0),
    LEGACY_ENERGY_INTAKE(ModObject.itemBasicCapacitor, CapacitorKeyType.ENERGY_INTAKE, Scaler.Factory.POWER, 80),
    LEGACY_ENERGY_BUFFER(ModObject.itemBasicCapacitor, CapacitorKeyType.ENERGY_BUFFER, Scaler.Factory.POWER, 100000),
    LEGACY_ENERGY_USE(ModObject.itemBasicCapacitor, CapacitorKeyType.ENERGY_USE, Scaler.Factory.POWER, 20);

    @Nonnull
    private final ModObject owner;
    @Nonnull
    private final CapacitorKeyType valueType;
    @Nonnull
    private Scaler scaler;
    @Nonnull
    private final String configKey;
    @Nonnull
    private final Config.Section configSection;
    @Nonnull
    private final String configComment;
    private final int defaultBaseValue;
    private int baseValue;

    private CapacitorKey(@Nonnull ModObject owner, CapacitorKeyType valueType, Scaler scaler, int defaultBaseValue) {
        this(owner, valueType, scaler, defaultBaseValue, Config.sectionCapacitor, null);
    }

    private CapacitorKey(@Nonnull ModObject owner, CapacitorKeyType valueType, @Nonnull Scaler scaler, @Nullable int defaultBaseValue, Config.Section configSection, String configKey) {
        this.owner = owner;
        this.valueType = valueType;
        this.scaler = scaler;
        this.configKey = CapacitorKeyHelper.createConfigKey(this, configKey);
        this.configSection = configSection;
        this.configComment = CapacitorKeyHelper.localizeComment(EnderIO.lang, this.configSection, this.configKey);
        this.baseValue = this.defaultBaseValue = defaultBaseValue;
    }

    @Override
    @Nonnull
    public ModObject getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public CapacitorKeyType getValueType() {
        return this.valueType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    @Nonnull
    public Scaler getScaler() {
        return this.scaler;
    }

    @Override
    public void setScaler(@Nonnull Scaler scaler) {
        this.scaler = scaler;
    }

    @Override
    @Nonnull
    public String getConfigKey() {
        return this.configKey;
    }

    @Override
    @Nonnull
    public Config.Section getConfigSection() {
        return this.configSection;
    }

    @Override
    @Nonnull
    public String getConfigComment() {
        return this.configComment;
    }

    @Override
    public int getDefaultBaseValue() {
        return this.defaultBaseValue;
    }

    @Override
    public int getBaseValue() {
        return this.baseValue;
    }

    @Override
    public void setBaseValue(int baseValue) {
        this.baseValue = baseValue;
    }

    public static void processConfig(Configuration config) {
        CapacitorKeyHelper.processConfig(config, CapacitorKey.values());
    }
}

