/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.api.capacitor.CapabilityCapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.NBTCapacitorData;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import org.apache.commons.lang3.tuple.Pair;

public class CapacitorHelper {
    private CapacitorHelper() {
    }

    @Nullable
    public static ICapacitorData getCapacitorDataFromItemStack(@Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return null;
        }
        ICapacitorData capData = CapacitorHelper.getNBTCapacitorDataFromItemStack(stack);
        if (capData != null) {
            return capData;
        }
        return (ICapacitorData)stack.getCapability(CapabilityCapacitorData.getCapNN(), null);
    }

    public static boolean isValidUpgrade(@Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        ICapacitorData capData = CapacitorHelper.getNBTCapacitorDataFromItemStack(stack);
        if (capData != null) {
            return true;
        }
        return stack.hasCapability(CapabilityCapacitorData.getCapNN(), null);
    }

    @Nullable
    protected static ICapacitorData getNBTCapacitorDataFromItemStack(@Nonnull ItemStack stack) {
        NBTTagCompound nbtRoot = stack.func_77978_p();
        if (nbtRoot == null) {
            return null;
        }
        if (!nbtRoot.func_150297_b("eiocap", (int)new NBTTagCompound().func_74732_a())) {
            return null;
        }
        NBTTagCompound nbtTag = nbtRoot.func_74775_l("eiocap");
        if (!nbtTag.func_150297_b("level", (int)new NBTTagFloat(0.0f).func_74732_a())) {
            return null;
        }
        float capLevel = nbtTag.func_74760_g("level");
        if (capLevel < 0.0f || capLevel >= 10.0f) {
            return null;
        }
        return new NBTCapacitorData(stack.func_77973_b().func_77667_c(stack), capLevel, nbtTag);
    }

    @Nonnull
    public static ItemStack addCapData(@Nonnull ItemStack stack, @Nonnull SetType setType, @Nullable ICapacitorKey key, float value) {
        NBTTagCompound root = stack.func_77978_p();
        if (root == null) {
            root = new NBTTagCompound();
            stack.func_77982_d(root);
        }
        NBTTagCompound tag = root.func_74775_l("eiocap");
        root.func_74782_a("eiocap", (NBTBase)tag);
        if (key == null) {
            CapacitorHelper.addCapData(tag, setType, value);
        } else {
            CapacitorHelper.addCapData(tag, setType, key, value);
        }
        return stack;
    }

    private static void addCapData(@Nonnull NBTTagCompound tag, @Nonnull SetType setType, float value) {
        switch (setType) {
            case LEVEL: {
                tag.func_74776_a("level", value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void addCapData(@Nonnull NBTTagCompound tag, @Nonnull SetType setType, @Nonnull ICapacitorKey key, float value) {
        switch (setType) {
            case NAME: {
                tag.func_74776_a(key.getName(), value);
                break;
            }
            case OWNER_TYPE: {
                NBTTagCompound subtag = tag.func_74775_l(key.getOwner().getUnlocalisedName());
                subtag.func_74776_a(key.getValueType().getName(), value);
                tag.func_74782_a(key.getOwner().getUnlocalisedName(), (NBTBase)subtag);
                break;
            }
            case TYPE: {
                tag.func_74776_a(key.getValueType().getName(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static List<Pair<String, Float>> getCapDataRaw(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("eiocap");
        if (tag == null) {
            return null;
        }
        ArrayList<Pair<String, Float>> result = new ArrayList<Pair<String, Float>>();
        for (String key : tag.func_150296_c()) {
            if (key == null || "level".equals(key) || !tag.func_150297_b(key, (int)new NBTTagFloat(0.0f).func_74732_a())) continue;
            result.add((Pair<String, Float>)Pair.of((Object)key, (Object)Float.valueOf(tag.func_74760_g(key))));
        }
        return result;
    }

    public static float getCapLevelRaw(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("eiocap");
        if (tag == null) {
            return 1.0f;
        }
        return tag.func_74760_g("level");
    }

    public static enum SetType {
        LEVEL,
        NAME,
        OWNER_TYPE,
        TYPE;

    }
}

