/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.painted;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.block.painted.TileEntityPaintedBlock;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.paint.render.PaintRegistry;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.BasicPainterTemplate;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockPaintedGlowstone
extends BlockGlowstone
implements ITileEntityProvider,
IPaintable.IBlockPaintableBlock,
IModObject.WithBlockItem,
ICustomSubItems {
    public static BlockPaintedGlowstone create(@Nonnull IModObject modObject) {
        BlockPaintedGlowstoneNonSolid result = new BlockPaintedGlowstoneNonSolid(modObject);
        super.init(modObject);
        return result;
    }

    public static BlockPaintedGlowstone create_solid(@Nonnull IModObject modObject) {
        BlockPaintedGlowstoneSolid result = new BlockPaintedGlowstoneSolid(modObject);
        super.init(modObject);
        return result;
    }

    protected BlockPaintedGlowstone(@Nonnull IModObject modObject) {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(1.0f);
        Prep.setNoCreativeTab((Block)this);
        modObject.apply(this);
    }

    private void init(@Nonnull IModObject modObject) {
        MachineRecipeRegistry.instance.registerRecipe("painter", new BasicPainterTemplate<BlockPaintedGlowstone>(this, Blocks.field_150426_aN));
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("cube_all", new ResourceLocation("minecraft", "block/cube_all"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemPaintedBlock((Block)this));
    }

    public boolean canSilkHarvest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player) {
        return world.func_175625_s(pos) instanceof IPaintable.IPaintableTileEntity;
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (Config.paintedGlowstoneRequireSilkTouch) {
            super.getDrops(drops, world, pos, state, fortune);
        }
        TileEntity te = world.func_175625_s(pos);
        drops.add((Object)this.createPaintedDrop(te));
    }

    private ItemStack createPaintedDrop(TileEntity te) {
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ItemStack itemstack = new ItemStack((Block)this);
            IBlockState paintSource = ((IPaintable.IPaintableTileEntity)te).getPaintSource();
            PaintUtil.setSourceBlock(itemstack, paintSource);
            return itemstack;
        }
        return new ItemStack(Blocks.field_150426_aN);
    }

    public void func_180657_a(final @Nonnull World worldIn, @Nonnull EntityPlayer player, final @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        if (Config.paintedGlowstoneRequireSilkTouch && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) <= 0) {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
            return;
        }
        this.supressed(player);
        player.func_71020_j(0.025f);
        NNList items = new NNList((Object[])new ItemStack[]{this.createPaintedDrop(te)});
        ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        items.apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack itemStack) {
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
            }
        });
    }

    private void supressed(EntityPlayer player) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PaintUtil.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PaintUtil.setSourceBlock(pickBlock, this.getPaintSource(state, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, null);
        blockStateWrapper.addCacheKey(0);
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        return this.getSubItems((Block)this, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }

    public static class BlockPaintedGlowstoneNonSolid
    extends BlockPaintedGlowstone
    implements IPaintable.INonSolidBlockPaintableBlock {
        protected BlockPaintedGlowstoneNonSolid(@Nonnull IModObject modObject) {
            super(modObject);
            this.field_149783_u = true;
            this.func_149713_g(0);
        }

        @SideOnly(value=Side.CLIENT)
        public float func_185485_f(@Nonnull IBlockState bs) {
            return 1.0f;
        }

        public boolean doesSideBlockRendering(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
            return false;
        }
    }

    public static class BlockPaintedGlowstoneSolid
    extends BlockPaintedGlowstone
    implements IPaintable.ISolidBlockPaintableBlock {
        protected BlockPaintedGlowstoneSolid(@Nonnull IModObject modObject) {
            super(modObject);
        }
    }
}

