/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.painted;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.block.painted.TileEntityPaintedBlock;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.paint.render.PaintRegistry;
import crazypants.enderio.base.paint.render.UVLock;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.BasicPainterTemplate;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockWall;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedFenceGate
extends BlockFenceGate
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IItemModelMapper,
IModObject.WithBlockItem,
ICustomSubItems {
    public static BlockPaintedFenceGate create(@Nonnull IModObject modObject) {
        BlockPaintedFenceGate result = new BlockPaintedFenceGate(modObject, BlockPlanks.EnumType.OAK);
        result.func_149711_c(2.0f).func_149752_b(5.0f);
        result.init(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new BasicPainterTemplate<BlockPaintedFenceGate>(result, Blocks.field_180390_bo, Blocks.field_180387_bt, Blocks.field_180391_bp, Blocks.field_180392_bq, Blocks.field_180386_br, Blocks.field_180385_bs));
        return result;
    }

    protected BlockPaintedFenceGate(@Nonnull IModObject modObject, BlockPlanks.EnumType material) {
        super(material);
        Prep.setNoCreativeTab((Block)this);
        modObject.apply(this);
        this.func_149672_a(SoundType.field_185848_a);
    }

    private void init(@Nonnull IModObject modObject) {
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("fence_gate_closed", new ResourceLocation("minecraft", "block/oak_fence_gate_closed"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("fence_gate_open", new ResourceLocation("minecraft", "block/oak_fence_gate_open"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("wall_gate_closed", new ResourceLocation("minecraft", "block/oak_wall_gate_closed"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("wall_gate_open", new ResourceLocation("minecraft", "block/oak_wall_gate_open"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemPaintedBlock((Block)this));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        EnumFacing.Axis enumfacing$axis = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k();
        if (enumfacing$axis == EnumFacing.Axis.Z && (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BlockWall || worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BlockWall) || enumfacing$axis == EnumFacing.Axis.X && (worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BlockWall || worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BlockWall)) {
            state = state.func_177226_a((IProperty)field_176467_M, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PaintUtil.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        NNList drops2 = new NNList();
        super.getDrops((NonNullList)drops2, world, pos, state, fortune);
        for (ItemStack drop : drops2) {
            PaintUtil.setSourceBlock((ItemStack)NullHelper.notnullM((Object)drop, (String)"null stack from getDrops()"), this.getPaintSource(state, world, pos));
        }
        drops.addAll((Collection)drops2);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PaintUtil.setSourceBlock(pickBlock, this.getPaintSource(state, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
        blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(state.func_177229_b((IProperty)field_185512_D)).addCacheKey(state.func_177229_b((IProperty)field_176466_a)).addCacheKey(state.func_177229_b((IProperty)field_176467_M));
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private IBakedModel mapRender(IBlockState state, @Nullable IBlockState paint) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        Boolean open = (Boolean)state.func_177229_b((IProperty)field_176466_a);
        Boolean wall = (Boolean)state.func_177229_b((IProperty)field_176467_M);
        String model = wall.booleanValue() ? (open.booleanValue() ? "wall_gate_open" : "wall_gate_closed") : (open != false ? "fence_gate_open" : "fence_gate_closed");
        switch (facing) {
            case EAST: {
                return PaintRegistry.getModel(IBakedModel.class, model, paint, new UVLock((IModelState)ModelRotation.X0_Y270));
            }
            case NORTH: {
                return PaintRegistry.getModel(IBakedModel.class, model, paint, new UVLock((IModelState)ModelRotation.X0_Y180));
            }
            case SOUTH: {
                return PaintRegistry.getModel(IBakedModel.class, model, paint, new UVLock(null));
            }
            case WEST: {
                return PaintRegistry.getModel(IBakedModel.class, model, paint, new UVLock((IModelState)ModelRotation.X0_Y90));
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBlockState stdOverlay = ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "fence_gate_closed", paintSource, new UVLock(null));
        IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "fence_gate_closed", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION2);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        list.add(model2);
        return list;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return 20;
    }

    public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        return this.getSubItems((Block)this, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (blockLayer == null || PaintUtil.canRenderInLayer(paintSource, blockLayer)) {
            quadCollector.addFriendlybakedModel(blockLayer, this.mapRender(state, paintSource), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

