/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.painted;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.block.painted.TileEntityPaintedBlock;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.paint.render.PaintRegistry;
import crazypants.enderio.base.paint.render.UVLock;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.BasicPainterTemplate;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedFence
extends BlockFence
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IItemModelMapper,
IModObject.WithBlockItem,
ICustomSubItems {
    public static BlockPaintedFence create(@Nonnull IModObject modObject) {
        BlockPaintedFence woodFence = new BlockPaintedFence(modObject, Material.field_151575_d, BlockPlanks.EnumType.OAK.func_181070_c(), SoundType.field_185848_a);
        woodFence.func_149711_c(2.0f).func_149752_b(5.0f);
        woodFence.init(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new BasicPainterTemplate<BlockPaintedFence>(woodFence, Blocks.field_180407_aO, Blocks.field_180405_aT, Blocks.field_180408_aP, Blocks.field_180404_aQ, Blocks.field_180403_aR, Blocks.field_180406_aS));
        return woodFence;
    }

    public static BlockPaintedFence create_stone(@Nonnull IModObject modObject) {
        BlockPaintedFence stoneFence = new BlockPaintedFence(modObject, Material.field_151576_e, MapColor.field_151655_K, SoundType.field_185851_d);
        stoneFence.func_149711_c(2.0f).func_149752_b(10.0f);
        stoneFence.init(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new BasicPainterTemplate<BlockPaintedFence>(stoneFence, Blocks.field_150386_bk));
        return stoneFence;
    }

    protected BlockPaintedFence(@Nonnull IModObject modObject, Material material, MapColor mapColor, @Nonnull SoundType sound) {
        super(material, mapColor);
        Prep.setNoCreativeTab((Block)this);
        modObject.apply(this);
        this.func_149672_a(sound);
    }

    private void init(@Nonnull IModObject modObject) {
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("fence_post", new ResourceLocation("minecraft", "block/oak_fence_post"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("fence_side", new ResourceLocation("minecraft", "block/oak_fence_side"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("fence_inventory", new ResourceLocation("minecraft", "block/oak_fence_inventory"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemPaintedBlock((Block)this));
    }

    public boolean canBeConnectedTo(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
        if (super.canBeConnectedTo(worldIn, pos, facing)) {
            return true;
        }
        IBlockState blockState2 = worldIn.func_180495_p(pos);
        Block block = blockState2.func_177230_c();
        if (block instanceof BlockPaintedFence) {
            return true;
        }
        if (block instanceof IPaintable.IBlockPaintableBlock) {
            IBlockState paintSource = ((IPaintable.IBlockPaintableBlock)block).getPaintSource(blockState2, worldIn, pos);
            return paintSource != null && paintSource.func_177230_c() instanceof BlockFence && paintSource.func_185904_a() == this.field_149764_J;
        }
        return false;
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PaintUtil.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(bs, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        NNList drops2 = new NNList();
        super.getDrops((NonNullList)drops2, world, pos, state, fortune);
        for (ItemStack drop : drops2) {
            PaintUtil.setSourceBlock((ItemStack)NullHelper.notnullM((Object)drop, (String)"null stack from getDrops()"), this.getPaintSource(state, world, pos));
        }
        drops.addAll((Collection)drops2);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PaintUtil.setSourceBlock(pickBlock, this.getPaintSource(state, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
        blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(state.func_177229_b((IProperty)BlockFence.field_176525_b)).addCacheKey(state.func_177229_b((IProperty)BlockFence.field_176526_a)).addCacheKey(state.func_177229_b((IProperty)BlockFence.field_176527_M)).addCacheKey(state.func_177229_b((IProperty)BlockFence.field_176528_N));
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private List<IBakedModel> mapRender(IBlockState state, @Nullable IBlockState paint) {
        ArrayList<IBakedModel> result = new ArrayList<IBakedModel>();
        result.add(PaintRegistry.getModel(IBakedModel.class, "fence_post", paint, null));
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176526_a)).booleanValue()) {
            result.add(PaintRegistry.getModel(IBakedModel.class, "fence_side", paint, new UVLock(null)));
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176525_b)).booleanValue()) {
            result.add(PaintRegistry.getModel(IBakedModel.class, "fence_side", paint, new UVLock((IModelState)ModelRotation.X0_Y90)));
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176527_M)).booleanValue()) {
            result.add(PaintRegistry.getModel(IBakedModel.class, "fence_side", paint, new UVLock((IModelState)ModelRotation.X0_Y180)));
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176528_N)).booleanValue()) {
            result.add(PaintRegistry.getModel(IBakedModel.class, "fence_side", paint, new UVLock((IModelState)ModelRotation.X0_Y270)));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBlockState stdOverlay = ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "fence_inventory", paintSource, new UVLock(null));
        IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "fence_inventory", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION2);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        list.add(model2);
        return list;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState bs, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        IBlockState bs = world.func_180495_p(pos);
        return bs.func_185904_a() == Material.field_151575_d ? 20 : super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        IBlockState bs = world.func_180495_p(pos);
        return bs.func_185904_a() == Material.field_151575_d ? 5 : super.getFireSpreadSpeed(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState bs, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        BlockPos otherPos;
        IBlockState otherBlockState;
        if (side.func_176740_k() != EnumFacing.Axis.Y && (otherBlockState = worldIn.func_180495_p(otherPos = pos.func_177972_a(side))).func_177230_c() instanceof BlockPaintedFence && this.getPaintSource(bs, worldIn, pos) == this.getPaintSource(otherBlockState, worldIn, otherPos)) {
            return false;
        }
        return super.func_176225_a(bs, worldIn, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        return this.getSubItems((Block)this, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (blockLayer == null || PaintUtil.canRenderInLayer(paintSource, blockLayer)) {
            for (IBakedModel model : this.mapRender(state, paintSource)) {
                quadCollector.addFriendlybakedModel(blockLayer, model, paintSource, MathHelper.func_180186_a((Vec3i)pos));
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

