/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.painted;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.IProducer;
import crazypants.enderio.base.block.darksteel.door.BlockDarkSteelDoor;
import crazypants.enderio.base.block.painted.BlockItemPaintedDoor;
import crazypants.enderio.base.block.painted.TileEntityPaintedBlock;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.paint.render.PaintRegistry;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.DoorPainterTemplate;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedDoor
extends BlockDarkSteelDoor
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IItemModelMapper,
IModObject.WithBlockItem {
    public static BlockPaintedDoor create_wooden(@Nonnull IModObject modObject) {
        BlockPaintedDoor result = new BlockPaintedDoor(modObject, Material.field_151575_d, false);
        result.init(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, new IProducer(){

            @Nonnull
            public Item getItem() {
                return Items.field_179570_aq;
            }
        }, (Block)Blocks.field_180413_ao));
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, new IProducer(){

            @Nonnull
            public Item getItem() {
                return Items.field_179572_au;
            }
        }, (Block)Blocks.field_180410_as));
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, new IProducer(){

            @Nonnull
            public Item getItem() {
                return Items.field_179568_as;
            }
        }, (Block)Blocks.field_180412_aq));
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, new IProducer(){

            @Nonnull
            public Item getItem() {
                return Items.field_179571_av;
            }
        }, (Block)Blocks.field_180409_at));
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, new IProducer(){

            @Nonnull
            public Item getItem() {
                return Items.field_179567_at;
            }
        }, (Block)Blocks.field_180411_ar));
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, new IProducer(){

            @Nonnull
            public Item getItem() {
                return Items.field_179569_ar;
            }
        }, (Block)Blocks.field_180414_ap));
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, modObject, (Block)result));
        return result;
    }

    public static BlockPaintedDoor create_iron(@Nonnull IModObject modObject) {
        BlockPaintedDoor result = new BlockPaintedDoor(modObject, Material.field_151573_f, false);
        result.init(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, new IProducer(){

            @Nonnull
            public Item getItem() {
                return Items.field_151139_aw;
            }
        }, (Block)Blocks.field_150454_av));
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, modObject, (Block)result));
        return result;
    }

    public static BlockPaintedDoor create_dark(@Nonnull IModObject modObject) {
        BlockPaintedDoor result = new BlockPaintedDoor(modObject, Material.field_151573_f, true);
        result.init(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, ModObject.blockDarkSteelDoor, ModObject.blockDarkSteelDoor.getBlockNN()));
        MachineRecipeRegistry.instance.registerRecipe("painter", new DoorPainterTemplate(result, modObject, (Block)result));
        return result;
    }

    protected BlockPaintedDoor(@Nonnull IModObject modObject, Material materialIn, boolean isBlastResistant) {
        super(modObject, materialIn, isBlastResistant);
        Prep.setNoCreativeTab((Block)this);
    }

    protected BlockDarkSteelDoor init(@Nonnull IModObject modObject) {
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("iron_door_bottom", new ResourceLocation("minecraft", "block/iron_door_bottom"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("iron_door_top", new ResourceLocation("minecraft", "block/iron_door_top"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("iron_door_bottom_rh", new ResourceLocation("minecraft", "block/iron_door_bottom_rh"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("iron_door_top_rh", new ResourceLocation("minecraft", "block/iron_door_top_rh"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("door_inventory", new ResourceLocation("minecraft", "item/iron_door"), PaintRegistry.PaintMode.ALL_TEXTURES);
        return this;
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemPaintedDoor(this));
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PaintUtil.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest && state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), worldIn.field_72995_K ? 11 : 3);
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            boolean flag1 = false;
            BlockPos blockpos1 = pos.func_177984_a();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                flag1 = true;
            }
            if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
                flag1 = true;
                if (iblockstate1.func_177230_c() == this) {
                    // empty if block
                }
            }
            if (flag1) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
                worldIn.func_175698_g(pos);
                return;
            }
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        NNList drops2 = new NNList();
        super.getDrops((NonNullList)drops2, world, pos, state, fortune);
        for (ItemStack drop : drops2) {
            PaintUtil.setSourceBlock((ItemStack)NullHelper.notnullM((Object)drop, (String)"null stack from getDrops()"), this.getPaintSource(state, world, pos));
        }
        drops.addAll((Collection)drops2);
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PaintUtil.setSourceBlock(pickBlock, this.getPaintSource(state, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
        blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(state.func_177229_b((IProperty)field_176520_a)).addCacheKey(state.func_177229_b((IProperty)field_176519_b)).addCacheKey(state.func_177229_b((IProperty)field_176523_O)).addCacheKey(state.func_177229_b((IProperty)field_176521_M));
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private IBakedModel mapRender(IBlockState state, @Nullable IBlockState paint) {
        String model;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        Boolean open = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)state.func_177229_b((IProperty)BlockDoor.field_176521_M);
        BlockDoor.EnumDoorHalf half = (BlockDoor.EnumDoorHalf)state.func_177229_b((IProperty)BlockDoor.field_176523_O);
        ModelRotation modelState = null;
        EnumFacing east = EnumFacing.EAST;
        EnumFacing south = EnumFacing.SOUTH;
        EnumFacing west = EnumFacing.WEST;
        EnumFacing north = EnumFacing.NORTH;
        BlockDoor.EnumDoorHalf lower = BlockDoor.EnumDoorHalf.LOWER;
        BlockDoor.EnumDoorHalf upper = BlockDoor.EnumDoorHalf.UPPER;
        BlockDoor.EnumHingePosition left = BlockDoor.EnumHingePosition.LEFT;
        BlockDoor.EnumHingePosition right = BlockDoor.EnumHingePosition.RIGHT;
        if (facing == east && half == lower && hinge == left && !open.booleanValue()) {
            model = "iron_door_bottom";
        } else if (facing == south && half == lower && hinge == left && !open.booleanValue()) {
            model = "iron_door_bottom";
            modelState = ModelRotation.X0_Y90;
        } else if (facing == west && half == lower && hinge == left && !open.booleanValue()) {
            model = "iron_door_bottom";
            modelState = ModelRotation.X0_Y180;
        } else if (facing == north && half == lower && hinge == left && !open.booleanValue()) {
            model = "iron_door_bottom";
            modelState = ModelRotation.X0_Y270;
        } else if (facing == east && half == lower && hinge == right && !open.booleanValue()) {
            model = "iron_door_bottom_rh";
        } else if (facing == south && half == lower && hinge == right && !open.booleanValue()) {
            model = "iron_door_bottom_rh";
            modelState = ModelRotation.X0_Y90;
        } else if (facing == west && half == lower && hinge == right && !open.booleanValue()) {
            model = "iron_door_bottom_rh";
            modelState = ModelRotation.X0_Y180;
        } else if (facing == north && half == lower && hinge == right && !open.booleanValue()) {
            model = "iron_door_bottom_rh";
            modelState = ModelRotation.X0_Y270;
        } else if (facing == east && half == lower && hinge == left && open.booleanValue()) {
            model = "iron_door_bottom_rh";
            modelState = ModelRotation.X0_Y90;
        } else if (facing == south && half == lower && hinge == left && open.booleanValue()) {
            model = "iron_door_bottom_rh";
            modelState = ModelRotation.X0_Y180;
        } else if (facing == west && half == lower && hinge == left && open.booleanValue()) {
            model = "iron_door_bottom_rh";
            modelState = ModelRotation.X0_Y270;
        } else if (facing == north && half == lower && hinge == left && open.booleanValue()) {
            model = "iron_door_bottom_rh";
        } else if (facing == east && half == lower && hinge == right && open.booleanValue()) {
            model = "iron_door_bottom";
            modelState = ModelRotation.X0_Y270;
        } else if (facing == south && half == lower && hinge == right && open.booleanValue()) {
            model = "iron_door_bottom";
        } else if (facing == west && half == lower && hinge == right && open.booleanValue()) {
            model = "iron_door_bottom";
            modelState = ModelRotation.X0_Y90;
        } else if (facing == north && half == lower && hinge == right && open.booleanValue()) {
            model = "iron_door_bottom";
            modelState = ModelRotation.X0_Y180;
        } else if (facing == east && half == upper && hinge == left && !open.booleanValue()) {
            model = "iron_door_top";
        } else if (facing == south && half == upper && hinge == left && !open.booleanValue()) {
            model = "iron_door_top";
            modelState = ModelRotation.X0_Y90;
        } else if (facing == west && half == upper && hinge == left && !open.booleanValue()) {
            model = "iron_door_top";
            modelState = ModelRotation.X0_Y180;
        } else if (facing == north && half == upper && hinge == left && !open.booleanValue()) {
            model = "iron_door_top";
            modelState = ModelRotation.X0_Y270;
        } else if (facing == east && half == upper && hinge == right && !open.booleanValue()) {
            model = "iron_door_top_rh";
        } else if (facing == south && half == upper && hinge == right && !open.booleanValue()) {
            model = "iron_door_top_rh";
            modelState = ModelRotation.X0_Y90;
        } else if (facing == west && half == upper && hinge == right && !open.booleanValue()) {
            model = "iron_door_top_rh";
            modelState = ModelRotation.X0_Y180;
        } else if (facing == north && half == upper && hinge == right && !open.booleanValue()) {
            model = "iron_door_top_rh";
            modelState = ModelRotation.X0_Y270;
        } else if (facing == east && half == upper && hinge == left && open.booleanValue()) {
            model = "iron_door_top_rh";
            modelState = ModelRotation.X0_Y90;
        } else if (facing == south && half == upper && hinge == left && open.booleanValue()) {
            model = "iron_door_top_rh";
            modelState = ModelRotation.X0_Y180;
        } else if (facing == west && half == upper && hinge == left && open.booleanValue()) {
            model = "iron_door_top_rh";
            modelState = ModelRotation.X0_Y270;
        } else if (facing == north && half == upper && hinge == left && open.booleanValue()) {
            model = "iron_door_top_rh";
        } else if (facing == east && half == upper && hinge == right && open.booleanValue()) {
            model = "iron_door_top";
            modelState = ModelRotation.X0_Y270;
        } else if (facing == south && half == upper && hinge == right && open.booleanValue()) {
            model = "iron_door_top";
        } else if (facing == west && half == upper && hinge == right && open.booleanValue()) {
            model = "iron_door_top";
            modelState = ModelRotation.X0_Y90;
        } else if (facing == north && half == upper && hinge == right && open.booleanValue()) {
            model = "iron_door_top";
            modelState = ModelRotation.X0_Y180;
        } else {
            return null;
        }
        return PaintRegistry.getModel(IBakedModel.class, model, paint, (IModelState)modelState);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBlockState stdOverlay = ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "door_inventory", paintSource, null);
        IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "door_inventory", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION3);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        list.add(model2);
        return list;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (blockLayer == null || PaintUtil.canRenderInLayer(paintSource, blockLayer)) {
            quadCollector.addFriendlybakedModel(blockLayer, this.mapRender(state, paintSource), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

