/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.detector;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.block.painted.TileEntityPaintedBlock;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperRelay;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDetector
extends BlockEio<TileEntityPaintedBlock>
implements IPaintable.ISolidBlockPaintableBlock,
IHaveRenderers {
    @Nonnull
    public static final PropertyBool IS_ON = PropertyBool.func_177716_a((String)"on");
    @Nonnull
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private final boolean silent;

    public static BlockDetector create(@Nonnull IModObject modObject) {
        BlockDetector result = new BlockDetector(modObject, false);
        result.init();
        return result;
    }

    public static BlockDetector createSilent(@Nonnull IModObject modObject) {
        BlockDetector result = new BlockDetector(modObject, true);
        result.init();
        return result;
    }

    protected BlockDetector(@Nonnull IModObject modObject, boolean silent) {
        super(modObject);
        this.silent = silent;
        this.func_149647_a(EnderIOTab.tabEnderIOMachines);
        this.initDefaultState();
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Override
    protected void init() {
        super.init();
        SmartModelAttacher.registerNoProps((Block)this);
    }

    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IS_ON, FACING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IS_ON, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a((IProperty)FACING, (Comparable)NNList.FACING.get(meta & 7));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)IS_ON) != false ? 8 : 0) + ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        IBlockState state;
        Item item = Item.func_150898_a((Block)this);
        Map locations = new DefaultStateMapper().func_178130_a((Block)this);
        ModelResourceLocation mrl = (ModelResourceLocation)locations.get(state = this.func_176223_P().func_177226_a((IProperty)IS_ON, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        if (mrl != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)mrl);
        }
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, @Nonnull Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, @Nonnull Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperRelay blockStateWrapper = new BlockStateWrapperRelay(state, world, pos);
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemPaintedBlock((Block)this));
    }

    public int func_180656_a(@Nonnull IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side.func_176734_d() != state.func_177229_b((IProperty)FACING) && (Boolean)state.func_177229_b((IProperty)IS_ON) != false ? 15 : 0;
    }

    public boolean func_149744_f(@Nonnull IBlockState state) {
        return true;
    }

    protected void playClickSound(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)IS_ON)).booleanValue()) {
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        IBlockState newState = state.func_177226_a((IProperty)IS_ON, (Comparable)Boolean.valueOf(this.isTargetBlockAir(state, world, pos)));
        if (newState != state) {
            world.func_175656_a(pos, newState);
            if (!this.silent) {
                this.playClickSound(world, pos, newState);
            }
        }
    }

    protected boolean isTargetBlockAir(IBlockState state, World world, BlockPos pos) {
        return world.func_175623_d(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)facing);
        return state.func_177226_a((IProperty)IS_ON, (Comparable)Boolean.valueOf(this.isTargetBlockAir(state, world, pos)));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PaintUtil.setSourceBlock(pickBlock, this.getPaintSource(world.func_180495_p(pos), (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public boolean isSideSolid(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return state.func_177229_b((IProperty)FACING) == side.func_176734_d();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

