/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.decoration;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.block.decoration.ItemBlockDecoration;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.property.EnumDecoBlock;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDecoration
extends Block
implements IHaveRenderers,
IModObject.WithBlockItem {
    @Nonnull
    private final EnumDecoBlock maxMeta;

    public static BlockDecoration create(@Nonnull IModObject modObject) {
        return new BlockDecoration(modObject, EnumDecoBlock.TYPE15);
    }

    protected BlockDecoration(@Nonnull IModObject modObject, @Nonnull EnumDecoBlock maxMeta) {
        super(Material.field_151576_e);
        this.func_149647_a(EnderIOTab.tabEnderIO);
        modObject.apply(this);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.initDefaultState();
        this.maxMeta = maxMeta;
    }

    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumDecoBlock.TYPE});
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new ItemBlockDecoration(this){

            @Nonnull
            public String func_77667_c(@Nonnull ItemStack stack) {
                return EnumDecoBlock.getTypeFromMeta(stack.func_77960_j()).getUnlocalizedName((Item)this);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        for (EnumDecoBlock type : NNList.of(EnumDecoBlock.class)) {
            list.add((Object)new ItemStack((Block)this, 1, EnumDecoBlock.getMetaFromType(type)));
            if (type != this.maxMeta) continue;
            return;
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumDecoBlock.TYPE, (Comparable)((Object)EnumDecoBlock.getTypeFromMeta(meta)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return EnumDecoBlock.getMetaFromType((EnumDecoBlock)((Object)state.func_177229_b(EnumDecoBlock.TYPE)));
    }

    public int func_180651_a(@Nonnull IBlockState st) {
        return this.func_176201_c(st);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        Item item = Item.func_150898_a((Block)this);
        Map locations = new DefaultStateMapper().func_178130_a((Block)this);
        for (EnumDecoBlock type : NNList.of(EnumDecoBlock.class)) {
            IBlockState state = this.func_176223_P().func_177226_a(EnumDecoBlock.TYPE, (Comparable)((Object)type));
            ModelResourceLocation mrl = (ModelResourceLocation)locations.get(state);
            if (mrl == null) continue;
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumDecoBlock.getMetaFromType(type), (ModelResourceLocation)mrl);
        }
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        EnumDecoBlock type = (EnumDecoBlock)((Object)state.func_177229_b(EnumDecoBlock.TYPE));
        return type != EnumDecoBlock.TYPE00 && type != EnumDecoBlock.TYPE14 && type != EnumDecoBlock.TYPE15;
    }

    public boolean isSideSolid(@Nonnull IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return this.func_149662_c(base_state);
    }
}

