/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.TileEntityBase;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.gui.handler.IEioGuiHandler;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.tool.ToolUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;

public abstract class BlockEio<T extends TileEntityEio>
extends BlockEnder<T>
implements IModObject.LifecycleInit,
IModObject.WithBlockItem {
    @Nonnull
    protected String permissionNodeWrenching = "(block not initialized)";
    @Nonnull
    protected String permissionNodeIOWrenching = "(block not initialized)";

    protected BlockEio(@Nonnull IModObject modObject) {
        super(modObject.getTEClass());
        modObject.apply(this);
        this.func_149647_a(EnderIOTab.tabEnderIOMachines);
    }

    protected BlockEio(@Nonnull IModObject modObject, @Nonnull Material mat) {
        super(modObject.getTEClass(), mat);
        modObject.apply(this);
        this.func_149647_a(EnderIOTab.tabEnderIOMachines);
    }

    protected BlockEio(@Nonnull IModObject modObject, @Nonnull Material mat, MapColor mapColor) {
        super(modObject.getTEClass(), mat, mapColor);
        modObject.apply(this);
        this.func_149647_a(EnderIOTab.tabEnderIOMachines);
    }

    protected void init() {
    }

    @Override
    public void init(@Nonnull IModObject modObject, @Nonnull FMLInitializationEvent event) {
        if (this.canBeWrenched()) {
            this.permissionNodeWrenching = PermissionAPI.registerNode((String)("enderio.wrench.break." + modObject.getUnlocalisedName()), (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Permission to wrench-break the block " + modObject.getUnlocalisedName() + " of Ender IO"));
            this.permissionNodeIOWrenching = PermissionAPI.registerNode((String)("enderio.wrench.iomode." + modObject.getUnlocalisedName()), (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Permission to set IO mode by wrench-clicking the block " + modObject.getUnlocalisedName() + " of Ender IO"));
        }
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ITool tool;
        if (this.shouldWrench(world, pos, entityPlayer, side) && ToolUtil.breakBlockWithTool((Block)this, world, pos, side, entityPlayer, hand, this.permissionNodeWrenching)) {
            return true;
        }
        TileEntityBase te = this.getTileEntity((IBlockAccess)world, pos);
        if (te instanceof AbstractMachineEntity && (tool = ToolUtil.getEquippedTool(entityPlayer, hand)) != null && !entityPlayer.func_70093_af() && tool.canUse(hand, entityPlayer, pos)) {
            if (!world.field_72995_K) {
                if (!PermissionAPI.hasPermission((GameProfile)entityPlayer.func_146103_bH(), (String)this.permissionNodeIOWrenching, (IContext)new BlockPosContext(entityPlayer, pos, state, side))) {
                    entityPlayer.func_145747_a((ITextComponent)Lang.WRENCH_DENIED.toChatServer());
                } else {
                    ((AbstractMachineEntity)te).toggleIoModeForFace(side);
                }
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, entityPlayer, hand, side, hitX, hitY, hitZ);
    }

    public boolean shouldWrench(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumFacing side) {
        return this.canBeWrenched();
    }

    protected boolean canBeWrenched() {
        return true;
    }

    protected boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumFacing side) {
        return this.openGui(world, pos, entityPlayer, side, 0);
    }

    public boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side, int param) {
        if (this instanceof IEioGuiHandler) {
            return ModObjectRegistry.getModObjectNN((Block)this).openGui(world, pos, entityPlayer, side, param);
        }
        return false;
    }

    @Nonnull
    protected BlockEnder.IShape<T> mkShape(final @Nonnull BlockFaceShape allFaces) {
        return new BlockEnder.IShape<T>(){

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face, @Nonnull T te) {
                IBlockState paintSource = ((TileEntityEio)((Object)te)).getPaintSource();
                if (paintSource != null) {
                    try {
                        return paintSource.func_193401_d(worldIn, pos, face);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.getBlockFaceShape(worldIn, state, pos, face, te);
            }

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return allFaces;
            }
        };
    }

    @Nonnull
    protected BlockEnder.IShape<T> mkShape(final @Nonnull BlockFaceShape upDown, final @Nonnull BlockFaceShape allSides) {
        return new BlockEnder.IShape<T>(){

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face, @Nonnull T te) {
                IBlockState paintSource = ((TileEntityEio)((Object)te)).getPaintSource();
                if (paintSource != null) {
                    try {
                        return paintSource.func_193401_d(worldIn, pos, face);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.getBlockFaceShape(worldIn, state, pos, face, te);
            }

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return face == EnumFacing.UP || face == EnumFacing.DOWN ? upDown : allSides;
            }
        };
    }

    @Nonnull
    protected BlockEnder.IShape<T> mkShape(final @Nonnull BlockFaceShape down, final @Nonnull BlockFaceShape up, final @Nonnull BlockFaceShape allSides) {
        return new BlockEnder.IShape<T>(){

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face, @Nonnull T te) {
                IBlockState paintSource = ((TileEntityEio)((Object)te)).getPaintSource();
                if (paintSource != null) {
                    try {
                        return paintSource.func_193401_d(worldIn, pos, face);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.getBlockFaceShape(worldIn, state, pos, face, te);
            }

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return face == EnumFacing.UP ? up : (face == EnumFacing.DOWN ? down : allSides);
            }
        };
    }

    @Nonnull
    protected BlockEnder.IShape<T> mkShape(final BlockFaceShape ... faces) {
        return new BlockEnder.IShape<T>(){

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face, @Nonnull T te) {
                IBlockState paintSource = ((TileEntityEio)((Object)te)).getPaintSource();
                if (paintSource != null) {
                    try {
                        return paintSource.func_193401_d(worldIn, pos, face);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.getBlockFaceShape(worldIn, state, pos, face, te);
            }

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return faces[face.ordinal()];
            }
        };
    }
}

