/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util.registry;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickRegistry {
    public static final TickRegistry PRE = new TickRegistry(TickEvent.Phase.START);
    public static final TickRegistry POST = new TickRegistry(TickEvent.Phase.END);
    private boolean currentlyTicking = false;
    private final TickEvent.Phase phase;
    private final List<Tuple<Reference<?>, Consumer<?>>> continuousCallbacksToAdd = new ArrayList();
    private final List<Tuple<Reference<?>, Consumer<?>>> singleCallbacksToAdd = new ArrayList();
    private final List<Tuple<Reference<?>, Consumer<?>>> continuousCallbacks = new ArrayList();
    private final List<Tuple<Reference<?>, Consumer<?>>> singleCallbacks = new ArrayList();

    private TickRegistry(TickEvent.Phase phase) {
        this.phase = phase;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public <T> boolean addContinuousCallback(T object, Consumer<T> callback) {
        return this.add(object, callback, this.continuousCallbacks, this.continuousCallbacksToAdd);
    }

    public <T> boolean addSingleCallback(T object, Consumer<T> callback) {
        return this.add(object, callback, this.singleCallbacks, this.singleCallbacksToAdd);
    }

    private <T> boolean add(T object, Consumer<T> callback, List<Tuple<Reference<?>, Consumer<?>>> list, List<Tuple<Reference<?>, Consumer<?>>> listToAdd) {
        boolean currentlyTicking = this.currentlyTicking;
        if (!currentlyTicking) {
            listToAdd = list;
        }
        WeakReference<T> reference = object == null ? null : new WeakReference<T>(object);
        listToAdd.add(new Tuple(reference, callback));
        return !currentlyTicking;
    }

    public <T> boolean remove(Consumer<T> callback) {
        ListIterator<Tuple<Reference<?>, Consumer<?>>> iter = this.continuousCallbacks.listIterator();
        while (iter.hasNext()) {
            Tuple<Reference<?>, Consumer<?>> t = iter.next();
            if (t.func_76340_b() != callback) continue;
            iter.set(new Tuple(new WeakReference<Object>(null), t.func_76340_b()));
        }
        return !this.currentlyTicking;
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (this.phase != event.phase) {
            return;
        }
        this.currentlyTicking = true;
        this.tickAndAdd(this.continuousCallbacks, this.continuousCallbacksToAdd, false);
        this.tickAndAdd(this.singleCallbacks, this.singleCallbacksToAdd, true);
        this.currentlyTicking = false;
    }

    private void tickAndAdd(List<Tuple<Reference<?>, Consumer<?>>> list, List<Tuple<Reference<?>, Consumer<?>>> toAdd, boolean clear) {
        ListIterator<Tuple<Reference<?>, Consumer<?>>> iter = list.listIterator();
        while (iter.hasNext()) {
            Tuple<Reference<?>, Consumer<?>> t = iter.next();
            Reference ref = (Reference)t.func_76341_a();
            Object o = null;
            if (ref != null) {
                o = ref.get();
            }
            if (ref != null && o == null) {
                if (clear) continue;
                iter.remove();
                continue;
            }
            ((Consumer)t.func_76340_b()).accept(o);
        }
        if (clear) {
            list.clear();
        }
        list.addAll(toAdd);
        toAdd.clear();
    }
}

