/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.network;

import aroma1997.core.log.LogHelper;
import aroma1997.core.network.AutoEncode;
import aroma1997.core.network.ClientSettable;
import aroma1997.core.network.EncodingType;
import aroma1997.core.network.PacketHandler;
import aroma1997.core.util.ReflectionUtil;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Level;

public class NetworkHelper {
    private static PacketHandler core = NetworkHelper.getPacketHandler("aroma1997core");
    public static Predicate<Field> ANNOTATION_ENCODE = field -> field.getAnnotation(AutoEncode.class) != null;
    public static Predicate<Field> CLIENT_SETTABLE = field -> field.getAnnotation(ClientSettable.class) != null || FMLCommonHandler.instance().getEffectiveSide().isServer();

    public static void sendPacketToPlayers(Packet<?> packet) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a(packet);
        } else {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a(packet);
        }
    }

    public static void sendPacketToPlayer(EntityPlayerMP player, Packet<?> packet) {
        player.field_71135_a.func_147359_a(packet);
    }

    public static void sendPacketToDimension(int dimension, Packet<?> packet) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148537_a(packet, dimension);
    }

    public static PacketHandler getPacketHandler(String modid) {
        return PacketHandler.getHandlerForMod(modid);
    }

    public static PacketHandler getCorePacketHandler() {
        return core;
    }

    public static String readString(ByteBuf buf) {
        int len = buf.readInt();
        if (len == -1) {
            return null;
        }
        char[] val = new char[len];
        for (int i = 0; i < val.length; ++i) {
            val[i] = buf.readChar();
        }
        return new String(val);
    }

    public static void writeString(ByteBuf buf, String str) {
        int len = str == null ? -1 : str.length();
        buf.writeInt(len);
        for (int i = 0; i < len; ++i) {
            buf.writeChar((int)str.charAt(i));
        }
    }

    public static void encodeAllInClass(Object obj, ByteBuf buf) {
        NetworkHelper.encodeAllInClass(obj, buf, ANNOTATION_ENCODE);
    }

    public static void encodeAllInClass(Object obj, ByteBuf buf, Predicate<Field> shouldEncode) {
        ByteBuf other = Unpooled.buffer();
        int amount = 0;
        for (Field field : ReflectionUtil.getAllFieldsInClassOrSuperclass(obj.getClass())) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (!shouldEncode.test(field)) continue;
            ++amount;
            NetworkHelper.writeString(other, field.getName());
            try {
                EncodingType.encode(other, field.get(obj));
            }
            catch (IllegalAccessException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        buf.writeInt(amount);
        buf.writeBytes(other);
    }

    public static void decodeAllInClass(Object obj, ByteBuf buf) {
        NetworkHelper.decodeAllInClass(obj, buf, CLIENT_SETTABLE);
    }

    public static void decodeAllInClass(Object obj, ByteBuf buf, Predicate<Field> canBeSet) {
        int amount = buf.readInt();
        Class<?> clazz = obj.getClass();
        for (int i = 0; i < amount; ++i) {
            String fieldName = NetworkHelper.readString(buf);
            try {
                Field field = ReflectionUtil.getFieldInClassOrSuperclass(clazz, fieldName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(obj, EncodingType.decode(buf));
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("Could not find field " + fieldName + " in network packet for class " + clazz.getCanonicalName(), e);
            }
            catch (SecurityException e) {
                Throwables.propagate((Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public static void encodeTeUpdate(TileEntity te, ByteBuf buf, Predicate<Field> shouldEncode) {
        EncodingType.TILE_ENTITY.encodeLocal(buf, te);
        NetworkHelper.encodeAllInClass(te, buf, shouldEncode);
    }

    public static void decodeTeUpdate(ByteBuf buf) {
        TileEntity te = (TileEntity)EncodingType.TILE_ENTITY.decodeLocal(buf);
        if (te != null) {
            NetworkHelper.decodeAllInClass(te, buf, CLIENT_SETTABLE);
        } else {
            int amount = buf.readInt();
            LogHelper.log(Level.WARN, "Received packet for te, but there's no TileEntity there.");
            for (int i = 0; i < amount; ++i) {
                LogHelper.log(Level.WARN, NetworkHelper.readString(buf) + ":" + EncodingType.decode(buf));
            }
        }
    }
}

