/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.network;

import aroma1997.core.Aroma1997Core;
import aroma1997.core.network.ByteBufWrapper;
import aroma1997.core.network.NetworkHelper;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class EncodingType
extends Enum<EncodingType> {
    public static final /* enum */ EncodingType NULL = new EncodingType(obj -> obj == null, (buf, obj) -> {}, buf -> null, true);
    public static final /* enum */ EncodingType BOOLEAN = new EncodingType(Boolean.class, false, ByteBuf::writeBoolean, ByteBuf::readBoolean, true);
    public static final /* enum */ EncodingType BYTE = new EncodingType(Byte.class, false, (buf, obj) -> buf.writeByte((int)obj.byteValue()), ByteBuf::readByte, true);
    public static final /* enum */ EncodingType SHORT = new EncodingType(Short.class, false, (buf, obj) -> buf.writeShort((int)obj.shortValue()), ByteBuf::readShort, true);
    public static final /* enum */ EncodingType CHARACTER = new EncodingType(Character.class, false, (buf, obj) -> buf.writeChar((int)obj.charValue()), ByteBuf::readChar, true);
    public static final /* enum */ EncodingType INTEGER = new EncodingType(Integer.class, false, ByteBuf::writeInt, ByteBuf::readInt, true);
    public static final /* enum */ EncodingType LONG = new EncodingType(Long.class, false, ByteBuf::writeLong, ByteBuf::readLong, true);
    public static final /* enum */ EncodingType FLOAT = new EncodingType(Float.class, false, ByteBuf::writeFloat, ByteBuf::readFloat, true);
    public static final /* enum */ EncodingType DOUBLE = new EncodingType(Double.class, false, ByteBuf::writeDouble, ByteBuf::readDouble, true);
    public static final /* enum */ EncodingType CLASS = new EncodingType(Class.class, false, (buf, obj) -> NetworkHelper.writeString(buf, obj.getCanonicalName()), buf -> {
        try {
            return Class.forName(NetworkHelper.readString(buf));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not decode class.", e);
        }
    }, true);
    public static final /* enum */ EncodingType ENUM = new EncodingType(Enum.class, true, (buf, obj) -> {
        CLASS.encodeLocal((ByteBuf)buf, obj.getClass());
        buf.writeInt(obj.ordinal());
    }, buf -> {
        String className = NetworkHelper.readString(buf);
        Class clazz = (Class)CLASS.decodeLocal((ByteBuf)buf);
        assert (clazz.isEnum());
        T[] values = clazz.getEnumConstants();
        int ordinal = buf.readInt();
        if (ordinal >= values.length) {
            throw new IllegalArgumentException("Could not decode network packet enum, because class " + className + " does not have enough enum fields: " + ordinal);
        }
        return (Enum)values[ordinal];
    }, true);
    public static final /* enum */ EncodingType ARRAY = new EncodingType(obj -> obj.getClass().isArray(), (buf, obj) -> {
        Class<?> contained = obj.getClass().getComponentType();
        int length = Array.getLength(obj);
        buf.writeInt(length);
        CLASS.encodeLocal((ByteBuf)buf, contained);
        for (int i = 0; i < length; ++i) {
            EncodingType.encode(buf, Array.get(obj, i));
        }
    }, buf -> {
        int length = buf.readInt();
        Class clazz = (Class)CLASS.decodeLocal((ByteBuf)buf);
        Object array = Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, EncodingType.decode(buf));
        }
        return array;
    }, true);
    public static final /* enum */ EncodingType STRING = new EncodingType(String.class, false, NetworkHelper::writeString, NetworkHelper::readString, true);
    public static final /* enum */ EncodingType BLOCK_POS = new EncodingType(BlockPos.class, true, (buf, obj) -> buf.writeLong(obj.func_177986_g()), buf -> BlockPos.func_177969_a((long)buf.readLong()), true);
    public static final /* enum */ EncodingType CHUNK_POS = new EncodingType(ChunkPos.class, true, (buf, obj) -> {
        buf.writeInt(obj.field_77276_a);
        buf.writeInt(obj.field_77275_b);
    }, buf -> new ChunkPos(buf.readInt(), buf.readInt()), true);
    public static final /* enum */ EncodingType RESOURCE_LOCATION = new EncodingType(ResourceLocation.class, false, (buf, obj) -> NetworkHelper.writeString(buf, obj + ""), buf -> new ResourceLocation(NetworkHelper.readString(buf)), true);
    public static final /* enum */ EncodingType REGISTRY = new EncodingType(IForgeRegistryEntry.class, true, (buf, obj) -> {
        CLASS.encodeLocal((ByteBuf)buf, obj.getRegistryType());
        RESOURCE_LOCATION.encodeLocal((ByteBuf)buf, obj.getRegistryName());
    }, buf -> {
        Class clazz = (Class)CLASS.decodeLocal((ByteBuf)buf);
        IForgeRegistry registry = GameRegistry.findRegistry((Class)clazz);
        if (registry == null) {
            throw new IllegalArgumentException("Could not find appropriate registry for type " + clazz);
        }
        return registry.getValue((ResourceLocation)RESOURCE_LOCATION.decodeLocal((ByteBuf)buf));
    }, true);
    public static final /* enum */ EncodingType WORLD = new EncodingType(World.class, true, (buf, obj) -> buf.writeInt(obj.field_73011_w.getDimension()), buf -> Aroma1997Core.proxy.getWorld(buf.readInt()), false);
    public static final /* enum */ EncodingType TILE_ENTITY = new EncodingType(TileEntity.class, true, (buf, obj) -> {
        WORLD.encodeLocal((ByteBuf)buf, obj.func_145831_w());
        BLOCK_POS.encodeLocal((ByteBuf)buf, obj.func_174877_v());
    }, buf -> {
        World world = (World)WORLD.decodeLocal((ByteBuf)buf);
        if (world == null) {
            return null;
        }
        BlockPos pos = (BlockPos)BLOCK_POS.decodeLocal((ByteBuf)buf);
        return world.func_175625_s(pos);
    }, false);
    public static final /* enum */ EncodingType NBT = new EncodingType(NBTTagCompound.class, false, (buf, object) -> {
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)object, (DataOutput)new ByteBufWrapper((ByteBuf)buf));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }, buf -> {
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufWrapper((ByteBuf)buf), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }, true);
    public static final /* enum */ EncodingType ITEM_STACK = new EncodingType(ItemStack.class, false, (buf, object) -> {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt = object.func_77955_b(nbt);
        NBT.encodeLocal((ByteBuf)buf, nbt);
    }, buf -> new ItemStack((NBTTagCompound)NBT.decodeLocal((ByteBuf)buf)), true);
    public static final EncodingType[] VALUES;
    private final Predicate<Object> matches;
    private final BiConsumer<ByteBuf, Object> encode;
    private final Function<ByteBuf, ?> decode;
    private final boolean threadsafe;
    private static final /* synthetic */ EncodingType[] $VALUES;

    public static EncodingType[] values() {
        return (EncodingType[])$VALUES.clone();
    }

    public static EncodingType valueOf(String name) {
        return Enum.valueOf(EncodingType.class, name);
    }

    private <T> EncodingType(Class<T> clazz, boolean fuzzy, BiConsumer<ByteBuf, T> encode, Function<ByteBuf, T> decode, boolean threadsafe) {
        this(obj -> fuzzy ? clazz.isInstance(obj) : clazz == obj.getClass(), encode, decode, threadsafe);
    }

    private <T> EncodingType(Predicate<Object> matches, BiConsumer<ByteBuf, T> encode, Function<ByteBuf, T> decode, boolean threadsafe) {
        this.matches = matches;
        this.encode = encode;
        this.decode = decode;
        this.threadsafe = threadsafe;
        if (this.ordinal() > 255) {
            throw new IllegalStateException("Too many network datatypes known. Please change value to a short.");
        }
    }

    public void encodeLocal(ByteBuf buf, Object o) {
        this.encode.accept(buf, o);
    }

    public Object decodeLocal(ByteBuf buf) {
        assert (this.threadsafe);
        return this.decode.apply(buf);
    }

    public static void encode(ByteBuf buf, Object o) {
        for (EncodingType type : VALUES) {
            if (!type.matches.test(o)) continue;
            buf.writeByte(type.ordinal());
            type.encodeLocal(buf, o);
            return;
        }
        throw new IllegalArgumentException("Tried to encode " + o + " from class " + o.getClass() + ", but no EncodingType could be found.");
    }

    public static Object decode(ByteBuf buf) {
        return VALUES[buf.readByte() & 0xFF].decodeLocal(buf);
    }

    static {
        $VALUES = new EncodingType[]{NULL, BOOLEAN, BYTE, SHORT, CHARACTER, INTEGER, LONG, FLOAT, DOUBLE, CLASS, ENUM, ARRAY, STRING, BLOCK_POS, CHUNK_POS, RESOURCE_LOCATION, REGISTRY, WORLD, TILE_ENTITY, NBT, ITEM_STACK};
        VALUES = EncodingType.values();
    }
}

