/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.log;

import aroma1997.core.Reference;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogHelperPre {
    private static final Logger logger = LogManager.getLogger((String)"Aroma1997Core");
    public static final boolean debugLoggingEnabled = LogHelperPre.debugLoggingEnabled();

    public static void log(Level level, String message) {
        logger.log(level, message);
    }

    public static void log(Level level, String[] messages) {
        for (String message : messages) {
            LogHelperPre.log(level, message);
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Logger genNewLogger(String name) {
        Logger newLogger = LogManager.getLogger((String)name);
        return newLogger;
    }

    public static void debugLog(Supplier<String> message) {
        if (LogHelperPre.debugLoggingEnabled()) {
            LogHelperPre.log(Level.OFF, message.get());
        }
    }

    public static void debugLog(String message) {
        if (LogHelperPre.debugLoggingEnabled()) {
            LogHelperPre.log(Level.OFF, message);
        }
    }

    public static void logException(String msg, Throwable t) {
        logger.log(Level.ERROR, msg, t);
    }

    private static boolean debugLoggingEnabled() {
        return Reference.VERSION.contains("b") || Reference.VERSION.equals("${version}") || System.getProperty("DEBUGGING") != null;
    }
}

