/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.command;

import aroma1997.core.client.util.Colors;
import aroma1997.core.command.AromaBaseCommand;
import aroma1997.core.command.AromaSubCommand;
import aroma1997.core.misc.TeleporterNormal;
import aroma1997.core.network.NetworkHelper;
import aroma1997.core.network.packets.CapePacket;
import aroma1997.core.util.ServerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public final class AromaCommand
extends AromaSubCommand {
    public AromaCommand() {
        super("aroma1997");
        this.addSubCommand(new ClientReloadCommand());
        this.addSubCommand(new SetupDeathCounter());
        this.addSubCommand(new DimensionCommand());
        this.addSubCommand(new TPCommand());
        this.addSubCommand(new TabCompleteCommand());
    }

    public static class TabCompleteCommand
    extends AromaBaseCommand {
        public TabCompleteCommand() {
            super("tabcomplete");
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                throw new CommandException("No subcommand found.", new Object[0]);
            }
            int position = -1;
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].equals("TAB")) continue;
                position = i;
                break;
            }
            if (position == -1) {
                throw new CommandException("TAB not found.", new Object[0]);
            }
            ICommand commandToExecute = (ICommand)server.func_71187_D().func_71555_a().get(args[0]);
            if (commandToExecute == null) {
                throw new CommandException("Command not found.", new Object[0]);
            }
            if (!commandToExecute.func_184882_a(server, sender)) {
                throw new CommandException("You do not have permission to execute the command.", new Object[0]);
            }
            String[] totalArgs = new String[args.length - 1];
            System.arraycopy(args, 1, totalArgs, 0, totalArgs.length);
            String[] preArgs = new String[position];
            System.arraycopy(args, 1, preArgs, 0, preArgs.length - 1);
            preArgs[preArgs.length - 1] = "";
            int commands = 0;
            Iterator iterator = commandToExecute.func_184883_a(server, sender, preArgs, sender.func_180425_c()).iterator();
            while (iterator.hasNext()) {
                String str;
                totalArgs[preArgs.length - 1] = str = (String)iterator.next();
                try {
                    commandToExecute.func_184881_a(server, sender, totalArgs);
                }
                catch (CommandException e) {
                    sender.func_145747_a(ServerUtil.getChatForString((Object)((Object)Colors.RED) + e.getMessage()));
                }
                ++commands;
            }
            sender.func_145747_a(ServerUtil.getChatForString("Done executing " + commands + " commands."));
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
            ArrayList<String> ret = new ArrayList<String>();
            String str = args[0];
            for (int i = 1; i < args.length; ++i) {
                str = str + " " + args[i];
            }
            ret.addAll(server.func_184104_a(sender, str, pos, pos != null));
            if (ret.size() > 1) {
                ret.add("TAB");
            }
            return TabCompleteCommand.func_175762_a((String[])args, ret);
        }

        @Override
        public String func_71518_a(ICommandSender sender) {
            return "/tabcomplete <command>";
        }
    }

    public static class TPCommand
    extends AromaBaseCommand {
        public TPCommand() {
            super("tp");
        }

        @Override
        public String func_71518_a(ICommandSender sender) {
            return "/tp <dimension> OR /tp <x> <y> <z> OR /tp <x> <y> <z> <dimension>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            BlockPos targetPos;
            int dim;
            WorldServer world = (WorldServer)sender.func_130014_f_();
            Entity entity = sender.func_174793_f();
            if (world == null || entity == null) {
                throw new CommandException("Cannot teleport current entity.", new Object[0]);
            }
            if (args.length == 1) {
                dim = CommandBase.func_175755_a((String)args[0]);
                targetPos = null;
            } else if (args.length == 3) {
                dim = world.field_73011_w.getDimension();
                targetPos = new BlockPos(CommandBase.func_175755_a((String)args[0]), CommandBase.func_175755_a((String)args[1]), CommandBase.func_175755_a((String)args[2]));
            } else if (args.length == 4) {
                targetPos = new BlockPos(CommandBase.func_175755_a((String)args[0]), CommandBase.func_175755_a((String)args[1]), CommandBase.func_175755_a((String)args[2]));
                dim = CommandBase.func_175755_a((String)args[3]);
            } else {
                throw new CommandException("Unknown parameters. Use /help to get more informatiomn about the command.", new Object[0]);
            }
            if (!DimensionManager.isDimensionRegistered((int)dim)) {
                throw new CommandException("No such dimension for dimension id " + dim, new Object[0]);
            }
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                server.func_184103_al().transferPlayerToDimension(player, dim, (Teleporter)new TeleporterNormal(server.func_71218_a(dim), targetPos));
            } else {
                server.func_184103_al().transferEntityToWorld(entity, dim, world, server.func_71218_a(dim), (Teleporter)new TeleporterNormal(world, targetPos));
            }
        }

        @Override
        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return ServerUtil.isPlayerAdmin(sender);
        }
    }

    public static class DimensionCommand
    extends AromaBaseCommand {
        public DimensionCommand() {
            super(new String[0]);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            World world = sender.func_130014_f_();
            if (world == null) {
                throw new CommandException("Cannot determine dimension for command sender.", new Object[0]);
            }
            int dimension = world.field_73011_w.getDimension();
            String dimensionName = world.field_73011_w.func_186058_p().func_186065_b();
            sender.func_145747_a(ServerUtil.getChatForString("You are currently in dimension " + dimension + " (" + dimensionName + ")"));
        }
    }

    public class SetupDeathCounter
    extends AromaBaseCommand {
        private ICommand commandScoreboard;

        public SetupDeathCounter() {
            super("setupdeathcounter");
        }

        private ICommand getCommandScoreboard(MinecraftServer server) {
            if (this.commandScoreboard == null) {
                this.commandScoreboard = (ICommand)server.func_71187_D().func_71555_a().get("scoreboard");
                if (this.commandScoreboard == null) {
                    throw new RuntimeException("Failed to get the Scoreboard Command.");
                }
            }
            return this.commandScoreboard;
        }

        private Scoreboard getScoreBoard(MinecraftServer server) {
            return server.func_71218_a(0).func_96441_U();
        }

        @Override
        public String func_71518_a(ICommandSender sender) {
            return "/setupDeathCounter OR /setupDeathCounter <location> OR /setupDeathCounter <location> <name>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            String location = "sidebar";
            String table = "Deaths";
            if (args != null && args.length > 0) {
                location = args[0];
            }
            if (args != null && args.length > 1) {
                table = args[1];
            }
            if (this.getScoreBoard(server).func_96518_b(table) == null) {
                server.func_71187_D().func_71556_a(sender, "/scoreboard objectives add " + table + " deathCount");
            }
            ScoreObjective objective = this.getScoreBoard(server).func_96518_b(table);
            for (int i = 0; i < 19; ++i) {
                ScoreObjective o1 = this.getScoreBoard(server).func_96539_a(i);
                if (o1 != objective) continue;
                server.func_71187_D().func_71556_a(sender, "/scoreboard objectives setdisplay " + Scoreboard.func_96517_b((int)i));
            }
            server.func_71187_D().func_71556_a(sender, "/scoreboard objectives setdisplay " + location + " " + table);
            sender.func_145747_a(ServerUtil.getChatForString((Object)((Object)Colors.YELLOW) + "Done."));
        }

        @Override
        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return this.getCommandScoreboard(server).func_184882_a(server, sender);
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] arg, BlockPos pos) {
            if (arg == null) {
                arg = new String[]{""};
            }
            if (arg.length == 1) {
                return this.getCommandScoreboard(server).func_184883_a(server, sender, new String[]{"objectives", "setdisplay", arg[0]}, pos);
            }
            return null;
        }
    }

    public class ClientReloadCommand
    extends AromaBaseCommand {
        public ClientReloadCommand() {
            super("reloadclient");
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            NetworkHelper.getCorePacketHandler().sendPacketToPlayers(new CapePacket());
            sender.func_145747_a(ServerUtil.getChatForString("Send packet to all players to reload client configs."));
        }
    }
}

