/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.models;

import java.nio.IntBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class VdUtil {
    public static final int quadVertexCount = 4;
    public static final VertexFormat vertexFormat = DefaultVertexFormats.field_176599_b;
    public static final int dataStride = vertexFormat.func_177338_f() / 4;
    private static final int[] faceShades = VdUtil.getFaceShades();

    public static IntBuffer getQuadBuffer() {
        return IntBuffer.allocate(4 * dataStride);
    }

    public static void generateVertex(float x, float y, float z, int color, float u, float v, EnumFacing facing, IntBuffer out) {
        VdUtil.generateVertex(x, y, z, color, u, v, facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e(), out);
    }

    public static void generateVertex(float x, float y, float z, int color, float u, float v, float nx, float ny, float nz, IntBuffer out) {
        out.put(Float.floatToRawIntBits(x));
        out.put(Float.floatToRawIntBits(y));
        out.put(Float.floatToRawIntBits(z));
        out.put(color);
        out.put(Float.floatToRawIntBits(u));
        out.put(Float.floatToRawIntBits(v));
        out.put(VdUtil.packNormals(nx, ny, nz));
    }

    public static void generateBlockVertex(float x, float y, float z, float u, float v, EnumFacing facing, IntBuffer out) {
        VdUtil.generateVertex(x, y, z, faceShades[facing.ordinal()], u, v, facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e(), out);
    }

    private static int packNormals(float nx, float ny, float nz) {
        return VdUtil.mapFloatToByte(nx) | VdUtil.mapFloatToByte(ny) << 8 | VdUtil.mapFloatToByte(nz) << 16;
    }

    private static int mapFloatToByte(float f) {
        assert (f >= -1.0f && f <= 1.0f);
        return Math.round(f * 127.0f) & 0xFF;
    }

    private static int[] getFaceShades() {
        int[] ret = new int[EnumFacing.field_82609_l.length];
        double[] faceBrightness = new double[]{0.5, 1.0, 0.8, 0.8, 0.6, 0.6};
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int brightness = MathHelper.func_76125_a((int)((int)(faceBrightness[facing.ordinal()] * 255.0)), (int)0, (int)255);
            ret[facing.ordinal()] = 0xFF000000 | brightness << 16 | brightness << 8 | brightness;
        }
        return ret;
    }
}

