/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.models;

import aroma1997.core.client.models.VdUtil;
import com.google.common.base.Throwables;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelHelper {
    private ModelHelper() {
    }

    public static IBakedModel getMissingModel() {
        return ModelHelper.getItemModelMesher().func_178083_a().func_174951_a();
    }

    public static ItemModelMesher getItemModelMesher() {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a();
    }

    public static IModel getModel(ResourceLocation rl) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)rl);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public static void addCuboid(float xS, float yS, float zS, float xE, float yE, float zE, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        float spriteU = sprite.func_94209_e();
        float spriteV = sprite.func_94206_g();
        float spriteWidth = sprite.func_94212_f() - spriteU;
        float spriteHeight = sprite.func_94210_h() - spriteV;
        IntBuffer quadBuffer = IntBuffer.allocate(28);
        block8: for (EnumFacing facing : faces) {
            boolean isFace;
            switch (facing) {
                case DOWN: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    isFace = yS == 0.0f;
                    break;
                }
                case UP: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    isFace = yE == 1.0f;
                    break;
                }
                case NORTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = zS == 0.0f;
                    break;
                }
                case SOUTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = zE == 1.0f;
                    break;
                }
                case WEST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = xS == 0.0f;
                    break;
                }
                case EAST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = xE == 1.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (quadBuffer.position() <= 0) continue;
            BakedQuad quad = ModelHelper.createQuad(Arrays.copyOf(quadBuffer.array(), quadBuffer.position()), facing, sprite);
            if (isFace) {
                if (faceQuads != null) {
                    faceQuads[facing.ordinal()].add(quad);
                }
            } else {
                generalQuads.add(quad);
            }
            quadBuffer.rewind();
        }
    }

    public static void addFlippedCuboid(float xS, float yS, float zS, float xE, float yE, float zE, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        float spriteU = sprite.func_94212_f();
        float spriteV = sprite.func_94210_h();
        float spriteWidth = sprite.func_94209_e() - spriteU;
        float spriteHeight = sprite.func_94206_g() - spriteV;
        IntBuffer quadBuffer = IntBuffer.allocate(28);
        block8: for (EnumFacing facing : faces) {
            boolean isFace;
            switch (facing) {
                case DOWN: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    isFace = yS == 0.0f;
                    break;
                }
                case UP: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    isFace = yE == 1.0f;
                    break;
                }
                case NORTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = zS == 0.0f;
                    break;
                }
                case SOUTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = zE == 1.0f;
                    break;
                }
                case WEST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = xS == 0.0f;
                    break;
                }
                case EAST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = xE == 1.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (quadBuffer.position() <= 0) continue;
            BakedQuad quad = ModelHelper.createQuad(Arrays.copyOf(quadBuffer.array(), quadBuffer.position()), facing, sprite);
            if (isFace) {
                if (faceQuads != null) {
                    faceQuads[facing.ordinal()].add(quad);
                }
            } else {
                generalQuads.add(quad);
            }
            quadBuffer.rewind();
        }
    }

    public static BakedQuad createQuad(int[] vertexData, EnumFacing side, TextureAtlasSprite sprite) {
        return new BakedQuad(vertexData, -1, side, sprite, true, VdUtil.vertexFormat);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation rl) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(rl + "");
    }
}

