/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.BlockThing;
import com.enderio.core.common.util.stackable.IThing;
import com.enderio.core.common.util.stackable.ItemStackThing;
import com.enderio.core.common.util.stackable.ItemThing;
import com.enderio.core.common.util.stackable.OreThing;
import com.enderio.core.common.util.stackable.Things;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

class StringThing
implements IThing {
    @Nonnull
    private final String name;

    StringThing(@Nullable String name) {
        this.name = name != null ? name : "";
    }

    @Override
    @Nullable
    public IThing bake() {
        String[] split;
        if (this.name.trim().isEmpty()) {
            return null;
        }
        if (Things.aliases.containsKey(this.name)) {
            return Things.aliases.get(this.name).bake();
        }
        String mod = "minecraft";
        String ident = this.name;
        boolean allowItem = true;
        boolean allowBlock = true;
        boolean allowOreDict = true;
        if (ident.startsWith("item:")) {
            allowOreDict = false;
            allowBlock = false;
            ident = ident.substring("item:".length());
        } else if (ident.startsWith("block:")) {
            allowOreDict = false;
            allowItem = false;
            ident = ident.substring("block:".length());
        } else if (ident.startsWith("oredict:")) {
            allowItem = false;
            allowBlock = false;
            ident = ident.substring("oredict:".length());
        }
        int meta = -1;
        if (ident.contains(":") && (split = ident.split(":", 3)) != null && split.length >= 2) {
            if (split[0] != null && !split[0].trim().isEmpty()) {
                mod = NullHelper.notnullJ(split[0], "variable lost its value from one moment to the next");
            }
            ident = split[1] != null && !split[1].trim().isEmpty() ? NullHelper.notnullJ(split[1], "variable lost its value from one moment to the next") : "null";
            if (split.length >= 3) {
                if ("*".equals(split[2])) {
                    meta = Short.MAX_VALUE;
                } else {
                    try {
                        meta = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }
        }
        ResourceLocation resourceLocation = new ResourceLocation(mod, ident);
        if (meta < 0) {
            Item item;
            if (allowBlock && Block.field_149771_c.func_148741_d((Object)resourceLocation)) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                return new BlockThing(block).bake();
            }
            if (allowItem && Item.field_150901_e.func_148741_d((Object)resourceLocation) && (item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation)) != null) {
                return new ItemThing(item).bake();
            }
            if (allowOreDict) {
                return new OreThing(ident).bake();
            }
        } else {
            Item item;
            if (allowItem && Item.field_150901_e.func_148741_d((Object)resourceLocation) && (item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation)) != null) {
                return new ItemStackThing(new ItemStack(item, 1, meta)).bake();
            }
            if (allowBlock && Block.field_149771_c.func_148741_d((Object)resourceLocation)) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                return new ItemStackThing(new ItemStack(block, 1, meta)).bake();
            }
        }
        return null;
    }

    @Override
    public boolean is(@Nullable Item item) {
        return false;
    }

    @Override
    public boolean is(@Nullable ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean is(@Nullable Block block) {
        return false;
    }

    @Override
    @Nonnull
    public NNList<Item> getItems() {
        return NNList.emptyList();
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getItemStacks() {
        return NNList.emptyList();
    }

    @Override
    @Nonnull
    public NNList<Block> getBlocks() {
        return NNList.emptyList();
    }

    public String toString() {
        return String.format("StringThing [name=%s]", this.name);
    }
}

