/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class NNList<E>
extends NonNullList<E> {
    @Nonnull
    public static final NNList<EnumFacing> FACING = NNList.of(EnumFacing.class);
    @Nonnull
    public static final NNList<EnumFacing> FACING_HORIZONTAL = new NNList<EnumFacing>(EnumFacing.field_176754_o);
    @Nonnull
    public static final NNList<BlockRenderLayer> RENDER_LAYER = NNList.of(BlockRenderLayer.class);
    @Nonnull
    public static final NNList<BlockPos> SHELL = new NNList();
    @Nonnull
    private static final NNList<Object> EMPTY;

    public NNList() {
    }

    public NNList(Collection<E> fillWith) {
        this.addAll(fillWith);
    }

    public NNList(int size, @Nonnull E fillWith) {
        for (int i = 0; i < size; ++i) {
            this.add(fillWith);
        }
    }

    @SafeVarargs
    public NNList(E ... fillWith) {
        Collections.addAll(this, fillWith);
    }

    protected NNList(List<E> list, E defaultElement) {
        super(list, defaultElement);
    }

    @Nonnull
    public NNList<E> copy() {
        return new NNList<E>(this);
    }

    @Nonnull
    public static <X> NNList<X> wrap(List<X> list) {
        return list instanceof NNList ? (NNList<Object>)((Object)list) : new NNList<Object>(list, null);
    }

    @Nonnull
    public static <X extends Enum<?>> NNList<X> of(Class<X> e) {
        NNList<X> list = new NNList<X>(e.getEnumConstants());
        return list;
    }

    @Nonnull
    public E next(E current) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != current) continue;
            if (i + 1 < this.size()) {
                return (E)this.get(i + 1);
            }
            return (E)this.get(0);
        }
        throw new InvalidParameterException();
    }

    @Nonnull
    public E prev(E current) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != current) continue;
            if (i > 0) {
                return (E)this.get(i - 1);
            }
            return (E)this.get(this.size() - 1);
        }
        throw new InvalidParameterException();
    }

    public NNList<E> apply(@Nonnull Callback<E> callback) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) {
                throw new NullPointerException();
            }
            callback.apply(e);
        }
        return this;
    }

    public boolean apply(@Nonnull ShortCallback<E> callback) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) {
                throw new NullPointerException();
            }
            if (!callback.apply(e)) continue;
            return true;
        }
        return callback.finish();
    }

    @Nonnull
    public NNIterator<E> iterator() {
        return new ItrImpl(super.iterator());
    }

    @Nonnull
    public NNIterator<E> fastIterator() {
        return new FastItrImpl();
    }

    @Nonnull
    public static <X> NNList<X> emptyList() {
        return EMPTY;
    }

    @SafeVarargs
    public final NNList<E> addAll(E ... el) {
        for (E e : el) {
            this.add(e);
        }
        return this;
    }

    public NNList<E> addIf(@Nullable E e) {
        if (e != null) {
            this.add(e);
        }
        return this;
    }

    @Nonnull
    public <T> T[] toArray(T[] a) {
        return super.toArray((Object[])a);
    }

    public NNList<E> removeAllByClass(Class<? extends E> clazz) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!clazz.isAssignableFrom(iterator.next().getClass())) continue;
            iterator.remove();
        }
        return this;
    }

    static {
        for (int y = -1; y <= 1; ++y) {
            for (int z = -1; z <= 1; ++z) {
                for (int x = -1; x <= 1; ++x) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    SHELL.add(new BlockPos(x, y, z));
                }
            }
        }
        Collections.shuffle(SHELL);
        EMPTY = new NNList<Object>(){

            public void add(int p_add_1_, Object p_add_2_) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private class FastItrImpl
    implements NNIterator<E> {
        int cursor = 0;

        private FastItrImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != NNList.this.size();
        }

        @Override
        @Nonnull
        public E next() {
            try {
                return NNList.this.get(this.cursor++);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ItrImpl<E>
    implements NNIterator<E> {
        private final Iterator<E> parent;

        public ItrImpl(Iterator<E> iterator) {
            this.parent = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.parent.hasNext();
        }

        @Override
        @Nonnull
        public E next() {
            E next = this.parent.next();
            if (next == null) {
                throw new NullPointerException();
            }
            return next;
        }

        @Override
        public void remove() {
            this.parent.remove();
        }
    }

    public static interface NNIterator<E>
    extends Iterator<E> {
        @Override
        @Nonnull
        public E next();
    }

    public static interface ShortCallback<E> {
        public boolean apply(@Nonnull E var1);

        default public boolean finish() {
            return false;
        }
    }

    public static interface Callback<E> {
        public void apply(@Nonnull E var1);
    }
}

