/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import com.enderio.core.common.transform.EnderCorePlugin;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EnderCoreTransformer
implements IClassTransformer {
    public static final Logger logger = LogManager.getLogger((String)"EnderCore");
    static final String containerFurnaceClass = "net.minecraft.inventory.ContainerFurnace";
    static final ObfSafeName containerFurnaceMethod = new ObfSafeName("transferStackInSlot", "func_82846_b");
    static final String containerFurnaceMethodSig = "(Lnet/minecraft/inventory/ContainerFurnace;Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;";
    static final String renderItemClass = "net.minecraft.client.renderer.RenderItem";
    static final ObfSafeName renderItemOverlayIntoGUIMethod = new ObfSafeName("renderItemOverlayIntoGUI", "func_180453_a");
    static final ObfSafeName renderItemAndEffectIntoGUI = new ObfSafeName("renderItemAndEffectIntoGUI", "func_184391_a");
    static final ObfSafeName renderItemDisplayName = new ObfSafeName("renderItemAndEffectIntoGUI, renderItemOverlayIntoGUI", "func_180453_a, func_184391_a");
    static final String entityPlayerClass = "net.minecraft.entity.player.EntityPlayer";
    static final String entityAICreeperSwellClass = "net.minecraft.entity.ai.EntityAICreeperSwell";
    static final ObfSafeName updateTaskMethod = new ObfSafeName("updateTask", "func_75246_d");
    static final String extendedBlockStorageClass = "net.minecraft.world.chunk.storage.ExtendedBlockStorage";
    static final ObfSafeName isEmptyMethod = new ObfSafeName("isEmpty", "func_76663_a");
    private final boolean inDev = System.getProperty("INDEV") != null;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassReader classReader;
        if (this.inDev && FMLLaunchHandler.side() == Side.SERVER) {
            ClassNode classNode = new ClassNode();
            classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            Iterator methods = classNode.methods.iterator();
            while (methods.hasNext()) {
                MethodNode methodNode = (MethodNode)methods.next();
                if (!methodNode.name.equals("getClientGuiElement") || !methodNode.desc.contains("GuiScreen")) continue;
                methods.remove();
            }
            ClassWriter cw = new ClassWriter(1);
            classNode.accept((ClassVisitor)cw);
            basicClass = cw.toByteArray();
        }
        if (transformedName.equals(extendedBlockStorageClass)) {
            return EnderCoreTransformer.transform(basicClass, extendedBlockStorageClass, isEmptyMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    boolean done = false;
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!isEmptyMethod.equals(m.name)) continue;
                        m.instructions.clear();
                        m.visitInsn(3);
                        m.visitInsn(172);
                        done = true;
                        break;
                    }
                    if (!done) {
                        logger.info("Transforming failed.");
                    }
                }
            });
        }
        if (transformedName.equals(containerFurnaceClass)) {
            return EnderCoreTransformer.transform(basicClass, containerFurnaceClass, containerFurnaceMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    boolean done = false;
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!containerFurnaceMethod.equals(m.name)) continue;
                        m.instructions.clear();
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        m.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
                        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/enderio/core/common/transform/EnderCoreMethods", "transferStackInSlot", EnderCoreTransformer.containerFurnaceMethodSig, false));
                        m.instructions.add((AbstractInsnNode)new InsnNode(176));
                        done = true;
                        break;
                    }
                    if (!done) {
                        logger.info("Transforming failed.");
                    }
                }
            });
        }
        if (transformedName.equals(renderItemClass)) {
            return EnderCoreTransformer.transform(basicClass, renderItemClass, renderItemDisplayName, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    int done = 0;
                    while (methods.hasNext()) {
                        InsnList toAdd;
                        MethodNode m = methods.next();
                        if (renderItemAndEffectIntoGUI.equals(m.name) && "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;II)V".equals(m.desc)) {
                            toAdd = new InsnList();
                            toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                            toAdd.add((AbstractInsnNode)new VarInsnNode(21, 3));
                            toAdd.add((AbstractInsnNode)new VarInsnNode(21, 4));
                            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "com/enderio/core/common/transform/EnderCoreMethods", "renderItemAndEffectIntoGUI", "(Lnet/minecraft/item/ItemStack;II)V", false));
                            m.instructions.insert(toAdd);
                            ++done;
                        }
                        if (!renderItemOverlayIntoGUIMethod.equals(m.name)) continue;
                        toAdd = new InsnList();
                        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                        toAdd.add((AbstractInsnNode)new VarInsnNode(21, 3));
                        toAdd.add((AbstractInsnNode)new VarInsnNode(21, 4));
                        toAdd.add((AbstractInsnNode)new MethodInsnNode(184, "com/enderio/core/common/transform/EnderCoreMethods", "renderItemOverlayIntoGUI", "(Lnet/minecraft/item/ItemStack;II)V", false));
                        boolean primed = false;
                        boolean onframe = false;
                        boolean applied = false;
                        Label target = null;
                        for (int i = 0; i < m.instructions.size(); ++i) {
                            AbstractInsnNode next = m.instructions.get(i);
                            if (!primed && target == null && next.getOpcode() == 182 && next instanceof MethodInsnNode && "showDurabilityBar".equals(((MethodInsnNode)next).name)) {
                                primed = true;
                            }
                            if (primed && next.getOpcode() == 153 && next instanceof JumpInsnNode) {
                                target = ((JumpInsnNode)next).label.getLabel();
                                primed = false;
                            }
                            if (target != null && next instanceof LabelNode && ((LabelNode)next).getLabel() == target) {
                                onframe = true;
                                continue;
                            }
                            if (!onframe || !(next instanceof FrameNode)) continue;
                            m.instructions.insert(next, toAdd);
                            ++done;
                            applied = true;
                            break;
                        }
                        if (applied) break;
                        logger.info("Transforming failed. Applying ersatz patch...");
                        m.instructions.insert(toAdd);
                        logger.warn("Ersatz patch applied, things may break!");
                        ++done;
                        break;
                    }
                    if (done != 2) {
                        logger.info("Transforming failed.");
                    }
                }
            });
        }
        if (transformedName.equals(entityPlayerClass)) {
            boolean deObf = !EnderCorePlugin.runtimeDeobfEnabled;
            classReader = new ClassReader(basicClass);
            ClassWriter cw = new ClassWriter(classReader, 0);
            MethodVisitor mv = cw.visitMethod(1, deObf ? "isElytraFlying" : "func_184613_cA", "()Z", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(42000, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "net/minecraft/entity/EntityLivingBase", deObf ? "isElytraFlying" : "func_184613_cA", "()Z", false);
            Label l1 = new Label();
            mv.visitJumpInsn(154, l1);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "com/enderio/core/common/transform/EnderCoreMethods", "isElytraFlying", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false);
            mv.visitJumpInsn(154, l1);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l1);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitInsn(4);
            mv.visitInsn(172);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLocalVariable("this", "Lnet/minecraft/entity/player/EntityPlayer;", null, l0, l2, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            classReader.accept((ClassVisitor)cw, 0);
            logger.info("Transforming net.minecraft.entity.player.EntityPlayer finished, added " + (deObf ? "isElytraFlying()" : "func_184613_cA()") + " overriding EntityLivingBase");
            return cw.toByteArray();
        }
        if (transformedName.equals(entityAICreeperSwellClass)) {
            return EnderCoreTransformer.transform(basicClass, entityAICreeperSwellClass, updateTaskMethod, new Transform(){

                @Override
                void transform(Iterator<MethodNode> methods) {
                    boolean done = false;
                    while (methods.hasNext()) {
                        MethodNode m = methods.next();
                        if (!updateTaskMethod.equals(m.name)) continue;
                        boolean deObf = EnderCoreTransformer.updateTaskMethod.deobf.equals(m.name);
                        InsnList list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAICreeperSwell", deObf ? "swellingCreeper" : "field_75269_a", "Lnet/minecraft/entity/monster/EntityCreeper;"));
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAICreeperSwell", deObf ? "creeperAttackTarget" : "field_75268_b", "Lnet/minecraft/entity/EntityLivingBase;"));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "com/enderio/core/common/transform/EnderCoreMethods", "isCreeperTarget", "(Lnet/minecraft/entity/monster/EntityCreeper;Lnet/minecraft/entity/EntityLivingBase;)Z", false));
                        LabelNode ldone = new LabelNode(new Label());
                        list.add((AbstractInsnNode)new JumpInsnNode(154, ldone));
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAICreeperSwell", deObf ? "swellingCreeper" : "field_75269_a", "Lnet/minecraft/entity/monster/EntityCreeper;"));
                        list.add((AbstractInsnNode)new InsnNode(2));
                        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/monster/EntityCreeper", deObf ? "setCreeperState" : "func_70829_a", "(I)V", false));
                        list.add((AbstractInsnNode)new InsnNode(177));
                        list.add((AbstractInsnNode)ldone);
                        list.add((AbstractInsnNode)new FrameNode(0, 1, new Object[]{"net/minecraft/entity/ai/EntityAICreeperSwell"}, 0, new Object[0]));
                        m.instructions.insert(list);
                        done = true;
                    }
                    if (!done) {
                        logger.info("Transforming failed.");
                    }
                }
            });
        }
        return basicClass;
    }

    protected static final byte[] transform(byte[] classBytes, String className, ObfSafeName methodName, Transform transformer) {
        logger.info("Transforming Class [" + className + "], Method [" + methodName.getName() + "]");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Iterator<MethodNode> methods = classNode.methods.iterator();
        transformer.transform(methods);
        ClassWriter cw = new ClassWriter(0);
        classNode.accept((ClassVisitor)cw);
        logger.info("Transforming " + className + " Finished.");
        return cw.toByteArray();
    }

    protected static abstract class Transform {
        protected Transform() {
        }

        abstract void transform(Iterator<MethodNode> var1);
    }

    protected static class ObfSafeName {
        final String deobf;
        final String srg;

        public ObfSafeName(String deobf, String srg) {
            this.deobf = deobf;
            this.srg = srg;
        }

        public String getName() {
            return EnderCorePlugin.runtimeDeobfEnabled ? this.srg : this.deobf;
        }

        public boolean equals(String obj) {
            if (obj != null) {
                return obj.equals(this.deobf) || obj.equals(this.srg);
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof String) {
                return obj.equals(this.deobf) || obj.equals(this.srg);
            }
            if (obj instanceof ObfSafeName) {
                return ((ObfSafeName)obj).deobf.equals(this.deobf) && ((ObfSafeName)obj).srg.equals(this.srg);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

