/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.util.Log;
import com.google.common.base.Throwables;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ThreadedNetworkWrapper {
    @Nonnull
    private static final Map<Class<? extends IMessage>, SimpleNetworkWrapper> typesClient = new IdentityHashMap<Class<? extends IMessage>, SimpleNetworkWrapper>();
    @Nonnull
    private static final Map<Class<? extends IMessage>, SimpleNetworkWrapper> typesServer = new IdentityHashMap<Class<? extends IMessage>, SimpleNetworkWrapper>();
    @Nonnull
    private final SimpleNetworkWrapper parent;

    static synchronized void registerChannelMapping(Class<? extends IMessage> requestMessageType, @Nonnull SimpleNetworkWrapper parent, Side side) {
        (side == Side.CLIENT ? typesClient : typesServer).put(requestMessageType, parent);
    }

    private static synchronized SimpleNetworkWrapper getServerParent(IMessage message) {
        SimpleNetworkWrapper parent = typesClient.get(message.getClass());
        if (parent == null) {
            throw new RuntimeException("Trying to send unregistered network packet: " + message.getClass());
        }
        return parent;
    }

    private static synchronized SimpleNetworkWrapper getClientParent(IMessage message) {
        SimpleNetworkWrapper parent = typesServer.get(message.getClass());
        if (parent == null) {
            throw new RuntimeException("Trying to send unregistered network packet: " + message.getClass());
        }
        return parent;
    }

    public ThreadedNetworkWrapper(String channelName) {
        this.parent = new SimpleNetworkWrapper(channelName);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side) {
        if (messageHandler == requestMessageType) {
            throw new RuntimeException("Network packet " + requestMessageType + " needs a dedicated handler");
        }
        if (side == Side.CLIENT && FMLLaunchHandler.side() != Side.CLIENT) {
            this.parent.registerMessage(new NullHandler(), requestMessageType, discriminator, side);
            ThreadedNetworkWrapper.registerChannelMapping(requestMessageType, this.parent, side);
            return;
        }
        this.registerMessage(ThreadedNetworkWrapper.instantiate(messageHandler), requestMessageType, discriminator, side);
    }

    static <REQ extends IMessage, REPLY extends IMessage> IMessageHandler<? super REQ, ? extends REPLY> instantiate(Class<? extends IMessageHandler<? super REQ, ? extends REPLY>> handler) {
        try {
            return handler.newInstance();
        }
        catch (Throwable e) {
            Log.error("Failed to instanciate " + handler);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side) {
        this.parent.registerMessage(new Wrapper<REQ, REPLY>(messageHandler), requestMessageType, discriminator, side);
        ThreadedNetworkWrapper.registerChannelMapping(requestMessageType, this.parent, side);
    }

    public void sendToAll(IMessage message) {
        ThreadedNetworkWrapper.getServerParent(message).sendToAll(message);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        ThreadedNetworkWrapper.getServerParent(message).sendTo(message, player);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        ThreadedNetworkWrapper.getServerParent(message).sendToAllAround(message, point);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        ThreadedNetworkWrapper.getServerParent(message).sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        ThreadedNetworkWrapper.getClientParent(message).sendToServer(message);
    }

    public Packet<?> getPacketFrom(IMessage message) {
        return ThreadedNetworkWrapper.getServerParent(message).getPacketFrom(message);
    }

    public void sendToAllAround(IMessage packet, BlockPos pos, World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        PlayerChunkMap playerManager = worldServer.func_184164_w();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        for (Object playerObj : world.field_73010_i) {
            EntityPlayerMP player;
            if (!(playerObj instanceof EntityPlayerMP) || !playerManager.func_72694_a(player = (EntityPlayerMP)playerObj, chunkX, chunkZ)) continue;
            this.sendTo(packet, player);
        }
    }

    public void sendToAllAround(IMessage message, TileEntity te) {
        this.sendToAllAround(message, te.func_174877_v(), te.func_145831_w());
    }

    private final class Wrapper<REQ extends IMessage, REPLY extends IMessage>
    implements IMessageHandler<REQ, REPLY> {
        final IMessageHandler<REQ, REPLY> wrapped;

        public Wrapper(IMessageHandler<REQ, REPLY> wrapped) {
            this.wrapped = wrapped;
        }

        public REPLY onMessage(REQ message, MessageContext ctx) {
            Minecraft target;
            Object object = target = ctx.side == Side.CLIENT ? Minecraft.func_71410_x() : FMLCommonHandler.instance().getMinecraftServerInstance();
            if (target != null) {
                target.func_152344_a((Runnable)new Runner(this, message, ctx));
            }
            return null;
        }

        public String toString() {
            return this.wrapped.toString();
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Wrapper) {
                return this.wrapped.equals(((Wrapper)obj).wrapped);
            }
            return this.wrapped.equals(obj);
        }

        private static final class Runner
        implements Runnable {
            private final REQ message;
            private final MessageContext ctx;
            final /* synthetic */ Wrapper this$1;

            public Runner(REQ message, MessageContext ctx) {
                this.this$1 = var1_1;
                this.message = message;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                IMessage reply = this.this$1.wrapped.onMessage(this.message, this.ctx);
                if (reply != null) {
                    if (this.ctx.side == Side.CLIENT) {
                        this.this$1.ThreadedNetworkWrapper.this.sendToServer(reply);
                    } else {
                        EntityPlayerMP player = this.ctx.getServerHandler().field_147369_b;
                        this.this$1.ThreadedNetworkWrapper.this.sendTo(reply, player);
                    }
                }
            }
        }
    }

    private final class NullHandler<REQ extends IMessage, REPLY extends IMessage>
    implements IMessageHandler<REQ, REPLY> {
        private NullHandler() {
        }

        public REPLY onMessage(REQ message, MessageContext ctx) {
            return null;
        }
    }
}

