/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Handlers.Handler
public class RightClickCropHandler {
    private List<IPlantInfo> plants = Lists.newArrayList();
    private IPlantInfo currentPlant = null;
    public static final RightClickCropHandler INSTANCE = new RightClickCropHandler();

    private RightClickCropHandler() {
    }

    public void addCrop(IPlantInfo info) {
        this.plants.add(info);
    }

    @SubscribeEvent
    public void handleCropRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!ConfigHandler.allowCropRC) {
            return;
        }
        BlockPos pos = event.getPos();
        IBlockState blockState = event.getWorld().func_180495_p(pos);
        if (event.getEntityPlayer().func_184614_ca().func_190926_b() || !event.getEntityPlayer().func_70093_af()) {
            for (IPlantInfo info : this.plants) {
                if (info.getGrownState() != blockState) continue;
                if (event.getWorld().field_72995_K) {
                    event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                    break;
                }
                this.currentPlant = info;
                blockState.func_177230_c().func_176226_b(NullHelper.notnullF(event.getWorld(), "RightClickBlock.getWorld()"), pos, blockState, 0);
                this.currentPlant = null;
                IBlockState newBS = info.getResetState();
                event.getWorld().func_180501_a(pos, newBS, 3);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onHarvestDrop(BlockEvent.HarvestDropsEvent event) {
        if (this.currentPlant != null) {
            for (int i = 0; i < event.getDrops().size(); ++i) {
                ItemStack stack = (ItemStack)event.getDrops().get(i);
                if (stack.func_77973_b() != this.currentPlant.getSeed().func_77973_b() || this.currentPlant.getSeed().func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != this.currentPlant.getSeed().func_77952_i()) continue;
                stack.func_190918_g(1);
                if (!stack.func_190926_b()) break;
                event.getDrops().remove(i);
                break;
            }
        }
    }

    public static class LegacyPlantInfo
    implements IPlantInfo {
        public String seed;
        public String block;
        public int meta = 7;
        public int resetMeta = 0;
        public boolean optional;
        @Nonnull
        private transient Things seedStack = new Things();
        @Nonnull
        private transient IBlockState grownState = Blocks.field_150350_a.func_176223_P();
        @Nonnull
        private transient IBlockState resetState = Blocks.field_150350_a.func_176223_P();

        public LegacyPlantInfo() {
        }

        public LegacyPlantInfo(String seed, String block, int meta, int resetMeta) {
            this.seed = seed;
            this.block = block;
            this.meta = meta;
            this.resetMeta = resetMeta;
        }

        @Override
        public boolean init(@Nonnull String source) {
            String[] blockinfo;
            this.seedStack.add(this.seed);
            if (!this.seedStack.isValid()) {
                try {
                    this.seedStack.add("item:" + this.seed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.seedStack.isValid()) {
                    if (this.optional) {
                        return false;
                    }
                    throw new RuntimeException("invalid item specifier '" + this.seed + "' " + source);
                }
            }
            if ((blockinfo = this.block.split(":")).length != 2) {
                throw new RuntimeException("invalid block specifier '" + this.block + "' " + source);
            }
            Block mcblock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(NullHelper.notnullJ(blockinfo[0], "String.split()"), NullHelper.notnullJ(blockinfo[1], "String.split()")));
            if (mcblock == null) {
                if (this.optional) {
                    return false;
                }
                throw new RuntimeException("invalid block specifier '" + this.block + "' " + source);
            }
            if (mcblock instanceof BlockBeetroot) {
                this.meta = 3;
                this.resetMeta = 0;
                this.grownState = mcblock.func_176223_P().func_177226_a((IProperty)BlockBeetroot.field_185531_a, (Comparable)Integer.valueOf(3));
                this.resetState = mcblock.func_176223_P().func_177226_a((IProperty)BlockBeetroot.field_185531_a, (Comparable)Integer.valueOf(0));
            } else if (mcblock instanceof BlockCrops) {
                this.meta = ((BlockCrops)mcblock).func_185526_g();
                this.resetMeta = 0;
                this.grownState = mcblock.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(((BlockCrops)mcblock).func_185526_g()));
                this.resetState = mcblock.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(0));
            } else if (mcblock instanceof BlockNetherWart) {
                this.meta = 3;
                this.resetMeta = 0;
                this.grownState = mcblock.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(3));
                this.resetState = mcblock.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(0));
            } else {
                this.grownState = mcblock.func_176203_a(this.meta);
                this.resetState = mcblock.func_176203_a(this.resetMeta);
            }
            return true;
        }

        @Override
        @Nonnull
        public ItemStack getSeed() {
            return this.seedStack.getItemStack();
        }

        @Override
        @Nonnull
        public IBlockState getGrownState() {
            return this.grownState;
        }

        @Override
        @Nonnull
        public IBlockState getResetState() {
            return this.resetState;
        }
    }

    public static interface IPlantInfo {
        @Nonnull
        public ItemStack getSeed();

        @Nonnull
        public IBlockState getGrownState();

        @Nonnull
        public IBlockState getResetState();

        public boolean init(@Nonnull String var1);
    }
}

