/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.enchant;

import com.enderio.core.EnderCore;
import com.enderio.core.api.common.enchant.IAdvancedEnchant;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.NullHelper;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="endercore")
public class EnchantAutoSmelt
extends Enchantment
implements IAdvancedEnchant {
    private static EnchantAutoSmelt INSTANCE;
    private static final EnumEnchantmentType ENCH_TYPE;

    @Nullable
    public static EnchantAutoSmelt instance() {
        return INSTANCE;
    }

    private EnchantAutoSmelt() {
        super(Enchantment.Rarity.RARE, ENCH_TYPE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("autosmelt");
    }

    public int func_77317_b(int level) {
        return 60;
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_77325_b() {
        return 1;
    }

    @Nonnull
    public String func_77320_a() {
        return "enchantment.autosmelt";
    }

    public boolean isAllowedOnBooks() {
        return ConfigHandler.allowAutoSmelt;
    }

    public boolean func_92089_a(@Nonnull ItemStack stack) {
        return ConfigHandler.allowAutoSmelt && super.func_92089_a(stack);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack) {
        return ConfigHandler.allowAutoSmelt && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    @Nonnull
    public String[] getTooltipDetails(@Nonnull ItemStack stack) {
        return new String[]{EnderCore.lang.localize("enchantment.autosmelt.tooltip", false)};
    }

    @SubscribeEvent
    public static void register(@Nonnull RegistryEvent.Register<Enchantment> event) {
        if (ConfigHandler.allowAutoSmelt) {
            INSTANCE = new EnchantAutoSmelt();
            event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
            FMLInterModComms.sendMessage((String)"enderio", (String)"recipe:xml", (String)("<?xml version=\"1.0\" encoding=\"UTF-8\"?><recipes><recipe name=\"Enchanter: endercore:autosmelt\" required=\"true\" disabled=\"false\"><enchanting><input name=\"oredict:blockCoal\" amount=\"32\"/><enchantment name=\"" + EnderCore.DOMAIN + ":autosmelt\" costMultiplier=\"1\"/></enchanting></recipe></recipes>"));
        }
    }

    public boolean func_77326_a(@Nonnull Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_185306_r;
    }

    static {
        ENCH_TYPE = EnumHelper.addEnchantmentType((String)"EC_AUTOSMELT", (Predicate)new Predicate<Item>(){

            public boolean apply(@Nullable Item item) {
                return NullHelper.notnullM(item, "EnumEnchantmentType.canEnchantItem(null)").func_77645_m() && !(item instanceof ItemArmor) && !(item instanceof ItemSword) && !(item instanceof ItemBow) && !(item instanceof ItemFishingRod);
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(@Nullable Object obj) {
                return super.equals(obj);
            }
        });
    }
}

