/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class VertexTransformComposite
implements VertexTransform {
    @Nonnull
    public final VertexTransform[] xforms;

    public VertexTransformComposite(VertexTransform ... xforms) {
        this.xforms = xforms;
    }

    VertexTransformComposite(@Nonnull Collection<VertexTransform> xformsIn) {
        this.xforms = new VertexTransform[xformsIn.size()];
        int i = 0;
        Iterator<VertexTransform> iterator = xformsIn.iterator();
        while (iterator.hasNext()) {
            VertexTransform xform;
            this.xforms[i] = xform = iterator.next();
            ++i;
        }
    }

    @Override
    public void apply(@Nonnull Vertex vertex) {
        for (VertexTransform xform : this.xforms) {
            xform.apply(vertex);
        }
    }

    @Override
    public void apply(@Nonnull Vector3d vec) {
        for (VertexTransform xform : this.xforms) {
            xform.apply(vec);
        }
    }

    @Override
    public void applyToNormal(@Nonnull Vector3f vec) {
        for (VertexTransform xform : this.xforms) {
            xform.applyToNormal(vec);
        }
    }
}

